/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.templating.html.demo;

import com.arsdigita.templating.html.AttributeMap;
import com.arsdigita.templating.html.ContentHandler;
import com.arsdigita.templating.html.HTMLParser;
import com.arsdigita.templating.html.HTMLParserConfigurationException;
import com.arsdigita.templating.html.HTMLParserException;
import com.arsdigita.templating.html.HTMLParserFactory;
import com.arsdigita.templating.html.StringTemplate;
import com.arsdigita.util.Assert;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.log4j.Logger;

public class DemoTagHandler
implements ContentHandler {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$templating$html$demo$DemoTagHandler == null ? (class$com$arsdigita$templating$html$demo$DemoTagHandler = DemoTagHandler.class$("com.arsdigita.templating.html.demo.DemoTagHandler")) : class$com$arsdigita$templating$html$demo$DemoTagHandler));
    private static final String TOC_TAG = "toc";
    private static final String FOOTNOTE_TAG = "footnote";
    private static final String H0_TAG = "h0";
    private static final String H1_TAG = "h1";
    private static final String H2_TAG = "h2";
    private static final String H3_TAG = "h3";
    private static final String HEADER_PREFIX = "h";
    private StringBuffer m_buffer = new StringBuffer();
    private List m_headers = new ArrayList();
    private FootnoteTagHandler m_footnoteTagHandler;
    private Map m_handlers;
    private Stack m_stack = new Stack();
    private boolean m_inFootnote;
    private int m_tocPosition = -1;
    static /* synthetic */ Class class$com$arsdigita$templating$html$demo$DemoTagHandler;

    public DemoTagHandler() {
        this.m_handlers = new HashMap();
        this.m_handlers.put(TOC_TAG, new TocTagHandler());
        this.m_footnoteTagHandler = new FootnoteTagHandler();
        this.m_handlers.put(FOOTNOTE_TAG, this.m_footnoteTagHandler);
        HeaderTagHandler headerTagHandler = new HeaderTagHandler();
        this.m_handlers.put(H1_TAG, headerTagHandler);
        this.m_handlers.put(H2_TAG, headerTagHandler);
        this.m_handlers.put(H3_TAG, headerTagHandler);
    }

    public void startDocument() {
    }

    public void endDocument() throws HTMLParserException {
        this.m_footnoteTagHandler.generateFootnotes(this.m_buffer);
        this.generateToc();
    }

    private void generateToc() throws HTMLParserException {
        if (this.m_tocPosition < 0) {
            return;
        }
        Iterator headers = this.m_headers.iterator();
        if (!headers.hasNext()) {
            return;
        }
        StringBuffer toc = new StringBuffer();
        HeaderTag lastTag = new HeaderTag(H0_TAG);
        while (headers.hasNext()) {
            HeaderTag tag = (HeaderTag)headers.next();
            StringTemplate template = new StringTemplate("<a href=\"#$\">$</a>");
            template.bind(tag.getAnchor());
            template.bind(tag.getText());
            int distance = lastTag.distanceTo(tag);
            if (distance < 0) {
                for (int i = 0; i < -distance; ++i) {
                    toc.append("</li>\n</ol>\n");
                }
                toc.append("\t<li>");
            } else if (distance == 0) {
                toc.append("</li>\n\t<li>");
            } else {
                if (distance > 1) {
                    throw new HTMLParserException(tag.toString() + " does not have a preceding h" + (tag.getLevel() - 1) + " tag");
                }
                StringTemplate ol = new StringTemplate("\n<ol type=\"$\">\n\t<li>");
                ol.bind(tag.getType());
                toc.append(ol);
            }
            toc.append(template);
            lastTag = tag;
        }
        for (int i = 0; i < lastTag.getLevel(); ++i) {
            toc.append("</li>\n</ol>\n");
        }
        this.m_buffer = this.m_buffer.replace(this.m_tocPosition, this.m_tocPosition, toc.toString());
    }

    public void text(String text) throws HTMLParserException {
        if (this.m_stack.empty()) {
            this.m_buffer.append(text);
            return;
        }
        TagHandler handler = (TagHandler)this.m_stack.peek();
        handler.text(text);
    }

    public boolean isValid(String qName) {
        Assert.assertNotNull(qName, "element");
        return this.m_handlers.containsKey(qName);
    }

    public void startElement(String qName, AttributeMap attrs) throws HTMLParserException {
        if (!this.isValid(qName)) {
            throw new HTMLParserException(qName + " is not a valid tag.");
        }
        TagHandler handler = (TagHandler)this.m_handlers.get(qName);
        handler.startElement(qName, attrs);
        this.m_stack.push(handler);
        if (FOOTNOTE_TAG.equals(qName)) {
            if (this.m_inFootnote) {
                throw new HTMLParserException("nested footnote tags are not allowed.");
            }
            this.m_inFootnote = true;
        }
    }

    public void endElement(String qName) throws HTMLParserException {
        if (!this.isValid(qName)) {
            throw new HTMLParserException(qName + " is not a valid tag.");
        }
        if (FOOTNOTE_TAG.equals(qName)) {
            this.m_inFootnote = false;
        }
        if (this.m_stack.empty()) {
            throw new HTMLParserException("no matching opening tag for " + qName);
        }
        ((TagHandler)this.m_stack.pop()).endElement(qName);
    }

    public String getExtrapolatedDocument() {
        s_log.info((Object)("extrapolated:\n'" + this.m_buffer.toString() + "'"));
        return this.m_buffer.toString();
    }

    public static String getExtrapolatedDocument(String textWithCustomMarkup) throws HTMLParserException {
        HTMLParser parser = null;
        try {
            parser = HTMLParserFactory.newInstance();
        }
        catch (HTMLParserConfigurationException ex) {
            throw new HTMLParserException(ex);
        }
        parser.registerTag(TOC_TAG);
        parser.registerTag(FOOTNOTE_TAG);
        parser.registerTag(H1_TAG);
        parser.registerTag(H2_TAG);
        parser.registerTag(H3_TAG);
        DemoTagHandler handler = new DemoTagHandler();
        parser.parse(textWithCustomMarkup, handler);
        return handler.getExtrapolatedDocument();
    }

    private StringBuffer getCurrentBuffer() {
        return this.m_inFootnote ? this.m_footnoteTagHandler.getBuffer() : this.m_buffer;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class HeaderTagHandler
    implements TagHandler {
        private HeaderTag m_currentHeader;

        private HeaderTagHandler() {
        }

        public void startElement(String qName, AttributeMap attrs) throws HTMLParserException {
            if (this.m_currentHeader != null) {
                throw new HTMLParserException("Header tags like " + qName + " cannot be nested.");
            }
            this.m_currentHeader = new HeaderTag(qName);
            StringTemplate template = new StringTemplate("<$ id='$'>");
            String headerAnchor = DemoTagHandler.HEADER_PREFIX + (DemoTagHandler.this.m_headers.size() + 1);
            this.m_currentHeader.setAnchor(headerAnchor);
            template.bind(qName);
            template.bind(headerAnchor);
            DemoTagHandler.this.getCurrentBuffer().append(template);
        }

        public void text(String text) {
            this.m_currentHeader.setText(text);
            DemoTagHandler.this.getCurrentBuffer().append(text);
        }

        public void endElement(String qName) throws HTMLParserException {
            if (this.m_currentHeader.getText() == null || this.m_currentHeader.getText().equals("")) {
                throw new HTMLParserException("Cannot have an empty " + qName + " tag.");
            }
            DemoTagHandler.this.getCurrentBuffer().append("</").append(qName).append(">");
            DemoTagHandler.this.m_headers.add(this.m_currentHeader);
            this.m_currentHeader = null;
        }
    }

    private static class HeaderTag {
        public static final String TYPE_I = "I";
        private String m_tagName;
        private String m_text;
        private String m_anchor;
        private int m_level;

        public HeaderTag(String tagName) {
            Assert.assertNotNull(tagName, "tagName");
            this.m_tagName = tagName.toLowerCase();
            Assert.assertTrue(DemoTagHandler.H0_TAG.equals(tagName) || DemoTagHandler.H1_TAG.equals(tagName) || DemoTagHandler.H2_TAG.equals(tagName) || DemoTagHandler.H3_TAG.equals(tagName), tagName + " is not a supported header tag.");
            this.m_level = Integer.parseInt(this.m_tagName.substring(1));
        }

        public int distanceTo(HeaderTag tag) {
            Assert.assertNotNull(tag, "tag");
            return tag.m_level - this.m_level;
        }

        public int getLevel() {
            return this.m_level;
        }

        public String getName() {
            return this.m_tagName;
        }

        public void setText(String text) {
            this.m_text = text;
        }

        public String getText() {
            return this.m_text;
        }

        public void setAnchor(String anchor) {
            this.m_anchor = anchor;
        }

        public String getAnchor() {
            return this.m_anchor;
        }

        public String getType() {
            int type = this.getLevel() % 3;
            if (type == 1) {
                return TYPE_I;
            }
            if (type == 2) {
                return "A";
            }
            return "1";
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("<").append(this.getName()).append(">").append(this.getText());
            sb.append("</").append(this.getName()).append(">");
            return sb.toString();
        }
    }

    private class FootnoteTagHandler
    implements TagHandler {
        StringBuffer m_footnoteBuffer = new StringBuffer();
        List m_footnotes = new ArrayList();

        public void startElement(String qName, AttributeMap attrs) {
            StringTemplate template = new StringTemplate("<a href='#$'><sup id='$'>$</sup></a>");
            String footnoteAnchor = this.getAnchor(this.m_footnotes.size() + 1);
            template.bind(footnoteAnchor);
            template.bind(this.getBackAnchor(footnoteAnchor));
            template.bind(this.m_footnotes.size() + 1);
            DemoTagHandler.this.m_buffer.append(template);
        }

        public void text(String text) {
            this.m_footnoteBuffer.append(text);
        }

        public void endElement(String qName) {
            this.m_footnotes.add(this.m_footnoteBuffer.toString());
            this.m_footnoteBuffer = new StringBuffer();
        }

        public StringBuffer getBuffer() {
            return this.m_footnoteBuffer;
        }

        private String getAnchor(int footnoteNumber) {
            StringBuffer anchor = new StringBuffer(10);
            anchor.append("fn").append(footnoteNumber);
            return anchor.toString();
        }

        private String getBackAnchor(String anchor) {
            return "b" + anchor;
        }

        private void generateFootnotes(StringBuffer buffer) {
            if (this.m_footnotes.size() == 0) {
                return;
            }
            buffer.append("<hr size='1' noshade />\n<ol>\n");
            int count = 1;
            Iterator i = this.m_footnotes.iterator();
            while (i.hasNext()) {
                StringTemplate template = new StringTemplate("\t<li><p id='$'>$<a href='#$'><sup>back</sup></a></p></li>\n");
                String footnoteAnchor = this.getAnchor(count++);
                template.bind(footnoteAnchor);
                String footnote = (String)i.next();
                template.bind(footnote);
                String backAnchor = this.getBackAnchor(footnoteAnchor);
                template.bind(backAnchor);
                buffer.append(template);
            }
            buffer.append("</ol>\n");
        }
    }

    private class TocTagHandler
    implements TagHandler {
        private TocTagHandler() {
        }

        public void startElement(String qName, AttributeMap attrs) throws HTMLParserException {
            if (DemoTagHandler.this.m_tocPosition > -1) {
                throw new HTMLParserException("There can be only one toc");
            }
            if (DemoTagHandler.this.getCurrentBuffer() != DemoTagHandler.this.m_buffer) {
                throw new HTMLParserException("Improperly nested toc");
            }
            DemoTagHandler.this.m_tocPosition = DemoTagHandler.this.m_buffer.length();
        }

        public void text(String text) throws HTMLParserException {
            throw new HTMLParserException("toc should be an empty tag.");
        }

        public void endElement(String qName) {
        }
    }

    private static interface TagHandler {
        public void startElement(String var1, AttributeMap var2) throws HTMLParserException;

        public void endElement(String var1) throws HTMLParserException;

        public void text(String var1) throws HTMLParserException;
    }
}

