/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.toolbox.rebop;

import com.arsdigita.toolbox.rebop.BevelBox;
import com.arsdigita.toolbox.rebop.GenericComponent;
import com.arsdigita.toolbox.rebop.GenericDrawable;
import com.arsdigita.toolbox.rebop.GenericImage;
import com.arsdigita.toolbox.rebop.GenericLabel;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;

public class GenericButton
extends GenericComponent {
    public static final int STANDARD_PUSH_OFFSET = 2;
    private GenericComponent m_contentPane = new GenericComponent();
    private GenericImage m_icon = null;
    private Image m_upImage = null;
    private Image m_overImage = null;
    private Image m_downImage = null;
    private int m_hGap = 2;
    private int m_vGap = 2;
    protected GenericDrawable m_upDrawable;
    protected GenericDrawable m_overDrawable = this.m_upDrawable = new BevelBox(Color.lightGray, Color.white, Color.gray, this.m_hGap, false);
    protected GenericDrawable m_downDrawable = new BevelBox(Color.lightGray, Color.white, Color.gray, this.m_hGap, true);
    protected GenericDrawable m_disabledDrawable = new BevelBox(null, Color.blue, Color.blue, 0, true);
    private GenericLabel m_label;
    protected boolean m_selected = false;
    protected boolean m_mouseOver = false;
    private boolean m_toggleButton = false;
    private boolean m_unlatch = false;
    private Color m_labelColor = Color.blue;
    private Color m_selectedLabelColor = Color.white;
    private Color m_rolloverLabelColor = Color.yellow;
    private Color m_disabledLabelColor = Color.gray;
    private ActionListener m_actionListeners;
    private Dimension m_preferredSize = null;

    public GenericButton() {
        this.init(null, "", 2, 2);
    }

    public GenericButton(String label) {
        this.init(null, label, 2, 2);
    }

    public GenericButton(Image icon, String label) {
        this.init(icon, label, 2, 2);
    }

    public GenericButton(Image icon, String label, int hGap, int vGap) {
        this.init(icon, label, hGap, vGap);
    }

    public void setLabel(String label) {
        this.m_label.setName(label);
        this.doLayout();
    }

    public void addFormattedText(Font font, Color color, String string) {
        this.m_label.addFormattedText(font, color, string);
        this.updateLabelSize();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.m_label.setFont(font);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.updateColors();
        this.updateDrawable();
        this.repaint();
    }

    public void setLabelColor(Color color) {
        this.m_labelColor = color;
        this.updateColors();
    }

    public void setSelectedLabelColor(Color color) {
        this.m_selectedLabelColor = color;
        this.updateColors();
    }

    public void setRolloverLabelColor(Color color) {
        this.m_rolloverLabelColor = color;
        this.updateColors();
    }

    public void setIcon(Image icon) {
        this.m_icon.setImage(icon);
        this.m_contentPane.doLayout();
    }

    public void setToggleButton(boolean toggle) {
        this.m_toggleButton = toggle;
    }

    public void doLayout() {
        this.updateLabelSize();
        this.m_contentPane.doLayout();
        super.doLayout();
    }

    public boolean getToggleButton() {
        return this.m_toggleButton;
    }

    public GenericLabel getLabel() {
        return this.m_label;
    }

    public boolean getSelected() {
        return this.m_selected;
    }

    public void setSelected(boolean selected) {
        this.m_selected = selected;
    }

    public boolean getMouseOver() {
        return this.m_mouseOver;
    }

    public void setMouseOver(boolean mouseOver) {
        this.m_mouseOver = mouseOver;
    }

    public void setUpDrawable(GenericDrawable upDraw) {
        this.m_upDrawable = upDraw;
    }

    public void setDownDrawable(GenericDrawable downDraw) {
        this.m_downDrawable = downDraw;
    }

    public void setOverDrawable(GenericDrawable overDraw) {
        this.m_overDrawable = overDraw;
    }

    protected void init(Image icon, String label) {
        this.init(icon, label, 2, 2);
    }

    protected void init(Image icon, String label, int hGap, int vGap) {
        this.m_icon = new GenericImage(icon);
        this.m_icon.setXOffset(2);
        this.m_icon.setYOffset(2);
        this.m_hGap = hGap;
        this.m_vGap = vGap;
        this.m_overImage = this.m_upImage = icon;
        this.m_downImage = this.m_upImage;
        this.genericImageInit(this.m_icon, label);
    }

    protected LayoutManager getDefaultLayout() {
        return new GridBagLayout();
    }

    protected void genericImageInit(GenericImage icon, String label) {
        this.setLayout(this.getDefaultLayout());
        this.m_contentPane.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.m_label = new GenericLabel();
        this.addFormattedText(this.getFont(), this.m_labelColor, label);
        this.updateLabelSize();
        c.anchor = 18;
        this.m_contentPane.add((Component)this.m_icon, c);
        this.m_contentPane.add((Component)this.m_label, c);
        this.add(this.m_contentPane);
        this.addMouseListener(this);
        this.updateColors();
        this.updateDrawable();
    }

    public String toString() {
        return "GenericButton -- " + this.m_label.getName();
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void addNotify() {
        super.addNotify();
        this.updateLabelSize();
        this.updateDrawable();
        this.forceInvalid();
    }

    protected void updateLabelSize() {
        this.forceInvalid();
        int labelHeight = this.m_label.getSize().height;
        int myWidth = this.getSize().width;
        int labelWidth = myWidth - 2 * this.m_hGap - this.m_icon.getPreferredSize().width;
        if (0 >= labelWidth) {
            labelWidth = 4 * this.m_hGap;
        }
        this.m_label.setSize(labelWidth, labelHeight);
        int newWidth = this.m_label.getPreferredSize().width;
        if (newWidth != labelWidth) {
            this.m_label.setSize(newWidth + 2 * this.m_hGap, labelHeight);
        }
    }

    public void forceInvalid() {
        super.forceInvalid();
        this.m_label.forceUpdateSize();
        this.m_preferredSize = null;
    }

    public Dimension getPreferredSize() {
        if (null == this.m_preferredSize) {
            int height = this.m_label.getPreferredSize().height + 4 * this.m_vGap;
            int preferredWidth = this.m_label.getPreferredSize().width + 4 * this.m_hGap;
            Dimension preferredIconSize = this.m_icon.getPreferredSize();
            height = Math.max(height, preferredIconSize.height + this.m_vGap * 2);
            int iconWidth = this.m_icon.getPreferredSize().width;
            if (iconWidth > 0) {
                preferredWidth += (iconWidth += this.m_hGap);
            }
            int width = this.getSize().width;
            this.m_preferredSize = new Dimension(width, height);
        }
        return this.m_preferredSize;
    }

    protected void toggleSelected() {
        if (!this.isEnabled()) {
            return;
        }
        this.m_selected = !this.m_selected;
        this.m_label.setUseOffset(this.m_selected);
        this.m_icon.setUseOffset(this.m_selected);
        this.updateDrawable();
        this.updateColors();
        this.repaint();
    }

    protected void updateDrawable() {
        if (!this.isEnabled()) {
            this.setDrawable(this.m_disabledDrawable);
        } else if (this.m_selected) {
            this.setDrawable(this.m_downDrawable);
        } else if (this.m_mouseOver) {
            this.setDrawable(this.m_overDrawable);
        } else {
            this.setDrawable(this.m_upDrawable);
        }
    }

    protected void updateColors() {
        this.m_label.setForeground(this.getCurrentLabelColor());
    }

    protected Color getCurrentLabelColor() {
        if (!this.isEnabled()) {
            return this.m_disabledLabelColor;
        }
        if (this.m_selected) {
            return this.m_selectedLabelColor;
        }
        if (this.m_mouseOver) {
            return this.m_rolloverLabelColor;
        }
        return this.m_labelColor;
    }

    protected void toggleMouseOver(boolean mouseOver) {
        this.m_mouseOver = mouseOver;
        this.updateColors();
        this.updateDrawable();
        this.repaint();
    }

    public void mouseEntered(MouseEvent e) {
        this.toggleMouseOver(true);
    }

    public void mouseExited(MouseEvent e) {
        this.toggleMouseOver(false);
    }

    public void mousePressed(MouseEvent e) {
        if (this.m_toggleButton && !this.m_selected) {
            this.toggleSelected();
            ActionEvent ae = new ActionEvent(this, 501, "");
            this.processActionEvent(ae);
            super.mousePressed(e);
        } else {
            this.m_unlatch = true;
            this.toggleSelected();
        }
        this.repaint();
    }

    public void mouseReleased(MouseEvent e) {
        if (!this.m_toggleButton) {
            this.toggleSelected();
            ActionEvent ae = new ActionEvent(this, 502, "");
            this.processActionEvent(ae);
            super.mousePressed(e);
            this.repaint();
        } else if (this.m_selected) {
            if (this.m_unlatch) {
                this.toggleSelected();
                this.m_unlatch = false;
            }
            this.repaint();
        }
    }

    public void addActionListener(ActionListener l) {
        this.m_actionListeners = AWTEventMulticaster.add(this.m_actionListeners, l);
    }

    protected void processActionEvent(ActionEvent e) {
        if (null != this.m_actionListeners) {
            this.m_actionListeners.actionPerformed(e);
        }
    }
}

