/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.security.Initializer;
import com.arsdigita.ui.util.GlobalizationUtil;
import com.arsdigita.web.URL;
import com.arsdigita.xml.Element;

public class UserBanner
extends SimpleComponent {
    private static GlobalizedMessage s_help = GlobalizationUtil.globalize("ui.admin.help");
    private static GlobalizedMessage s_signout = GlobalizationUtil.globalize("ui.admin.signout");
    private static GlobalizedMessage s_portal = GlobalizationUtil.globalize("ui.admin.portal");
    private static GlobalizedMessage s_greet = GlobalizationUtil.globalize("ui.admin.greeting");

    public void generateXML(PageState state, Element parent) {
        Party party = Kernel.getContext().getParty();
        Element content = parent.newChildElement("ui:userBanner", "http://www.arsdigita.com/ui/1.0");
        this.exportAttributes(content);
        if (party != null && party instanceof User) {
            User user = (User)party;
            content.addAttribute("givenName", user.getPersonName().getGivenName());
            content.addAttribute("familyName", user.getPersonName().getFamilyName());
            content.addAttribute("screenName", user.getScreenName());
            content.addAttribute("primaryEmail", user.getPrimaryEmail().toString());
            content.addAttribute("userID", user.getOID().toString());
        }
        content.addAttribute("helpLabel", (String)s_help.localize(state.getRequest()));
        content.addAttribute("portalLabel", (String)s_portal.localize(state.getRequest()));
        content.addAttribute("signoutLabel", (String)s_signout.localize(state.getRequest()));
        content.addAttribute("greeting", (String)s_greet.localize(state.getRequest()));
        content.addAttribute("workspaceURL", URL.there(state.getRequest(), Initializer.getFullURL(Initializer.WORKSPACE_PAGE_KEY, state.getRequest())).toString());
        content.addAttribute("loginURL", URL.there(state.getRequest(), Initializer.getFullURL(Initializer.LOGIN_PAGE_KEY, state.getRequest())).toString());
        content.addAttribute("logoutURL", URL.there(state.getRequest(), Initializer.getFullURL(Initializer.LOGOUT_PAGE_KEY, state.getRequest())).toString());
    }
}

