/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.ui.admin;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.list.ListCellRenderer;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.EmailAddress;
import com.arsdigita.kernel.User;
import com.arsdigita.ui.admin.AdminConstants;
import com.arsdigita.ui.admin.EmailListModelBuilder;
import java.math.BigDecimal;

class EmailList
extends List
implements ListCellRenderer,
AdminConstants,
ActionListener {
    public EmailList() {
        this.setModelBuilder(new EmailListModelBuilder());
        this.setCellRenderer(this);
        this.addActionListener(this);
    }

    public Component getComponent(List list, PageState state, Object value, String key, int index, boolean isSelected) {
        SimpleContainer c = new SimpleContainer();
        if (value != null) {
            ControlLink link = new ControlLink(AdminConstants.USER_FORM_DELETE_ADDITIONAL_EMAIL);
            link.setClassAttr("deleteLink");
            c.add(new Label(value.toString()));
            c.add(link);
        }
        return c;
    }

    public void actionPerformed(ActionEvent e) {
        PageState ps = e.getPageState();
        BigDecimal userID = (BigDecimal)ps.getValue(AdminConstants.USER_ID_PARAM);
        if (userID != null) {
            User user = null;
            try {
                user = User.retrieve(userID);
            }
            catch (DataObjectNotFoundException exc) {
                return;
            }
            String email = (String)this.getSelectedKey(ps);
            if (email != null) {
                EmailAddress addr = new EmailAddress(email);
                user.removeEmailAddress(addr);
                user.save();
            }
        }
    }
}

