/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.ui.admin;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.tree.TreeModel;
import com.arsdigita.bebop.tree.TreeNode;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.ACSObjectCollection;
import com.arsdigita.kernel.Group;
import com.arsdigita.kernel.GroupCollection;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.ui.admin.GroupTreeNode;
import com.arsdigita.ui.admin.RootTreeNode;
import java.math.BigDecimal;
import java.util.Iterator;

public class GroupTreeModel
implements TreeModel {
    public TreeNode getRoot(PageState data) {
        return new RootTreeNode();
    }

    public boolean hasChildren(TreeNode n, PageState ps) {
        if (n instanceof RootTreeNode) {
            return true;
        }
        Session session = SessionManager.getSession();
        DataQuery query = session.retrieveQuery("com.arsdigita.ui.admin.SubGroupCount");
        query.setParameter("groupID", new BigDecimal((String)n.getKey()));
        int count = 0;
        if (query.next()) {
            count = ((BigDecimal)query.get("count")).intValue();
        }
        query.close();
        return count > 0;
    }

    public Iterator getChildren(TreeNode n, PageState ps) {
        if (n instanceof RootTreeNode) {
            Session ssn = SessionManager.getSession();
            DataCollection coll = ssn.retrieve("com.arsdigita.kernel.Group");
            coll.addInSubqueryFilter("id", "com.arsdigita.ui.admin.AllNoParentGroups");
            return new GroupIterator(new ACSObjectCollection(coll));
        }
        Group group = null;
        try {
            group = new Group(new BigDecimal((String)n.getKey()));
        }
        catch (DataObjectNotFoundException ed) {
            return null;
        }
        GroupCollection coll = group.getSubgroups();
        return new GroupIterator(coll);
    }

    private class GroupIterator
    implements Iterator {
        private ACSObjectCollection m_coll;

        public GroupIterator(ACSObjectCollection coll) {
            this.m_coll = coll;
        }

        public boolean hasNext() {
            return this.m_coll.next();
        }

        public Object next() {
            return new GroupTreeNode(this.m_coll.getACSObject());
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

