/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.ui.admin;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Resettable;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.list.ListCellRenderer;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.ui.admin.AdminConstants;
import com.arsdigita.ui.admin.SearchAndListModel;
import com.arsdigita.util.LockableImpl;

class SearchAndList
extends SimpleContainer
implements AdminConstants,
Resettable {
    private static final String FORM_INPUT_NAME = "query";
    private static final GlobalizedMessage LABEL_SUBMIT = new GlobalizedMessage("ui.admin.searchAndList.submit", "com.arsdigita.ui.admin.AdminResources");
    private static final GlobalizedMessage SEARCH_AGAIN = new GlobalizedMessage("ui.admin.searchAndList.submitAgain", "com.arsdigita.ui.admin.AdminResources");
    private Form m_searchForm;
    private List m_searchResultList;
    private ParameterModel m_queryModel;
    private SearchAndListModel m_listModel;
    private SimpleContainer m_searchResultContainer;
    private ListModelBuilder m_listModelBuilder = new SearchListModelBuilder();
    private FormProcessListener m_formProcessListener = new FormProcessListener(){

        public void process(FormSectionEvent e) throws FormProcessException {
            FormData data = e.getFormData();
            PageState state = e.getPageState();
            String query = (String)data.get(SearchAndList.FORM_INPUT_NAME);
            boolean visible = false;
            visible = query == null || query.equals("");
            SearchAndList.this.m_listModel.setQuery(query);
            SearchAndList.this.m_searchForm.setVisible(state, visible);
            SearchAndList.this.m_searchResultContainer.setVisible(state, !visible);
        }
    };

    public SearchAndList(String name) {
        this.m_searchForm = new Form(name, new BoxPanel(1));
        this.m_queryModel = new StringParameter(FORM_INPUT_NAME);
        TextField query = new TextField(this.m_queryModel);
        query.addValidationListener(new NotNullValidationListener());
        this.m_searchForm.add(query);
        this.m_searchForm.add(new Submit(LABEL_SUBMIT));
        this.m_searchForm.addProcessListener(this.m_formProcessListener);
        this.add(this.m_searchForm);
        this.m_searchResultContainer = new SimpleContainer();
        this.add(this.m_searchResultContainer);
        this.m_searchResultList = new List();
        this.m_searchResultList.setClassAttr("SearchResultList");
        this.m_searchResultList.setModelBuilder(this.m_listModelBuilder);
        ActionLink link = new ActionLink(new Label(SEARCH_AGAIN));
        link.setClassAttr("actionLink");
        link.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState state = e.getPageState();
                SearchAndList.this.m_searchForm.setVisible(state, true);
                SearchAndList.this.m_searchResultContainer.setVisible(state, false);
            }
        });
        this.m_searchResultContainer.add(this.m_searchResultList);
        this.m_searchResultContainer.add(link);
    }

    public void addChangeListener(ChangeListener l) {
        this.m_searchResultList.addChangeListener(l);
    }

    public Object getSelectedKey(PageState ps) {
        return this.m_searchResultList.getSelectedKey(ps);
    }

    public void clearSelection(PageState ps) {
        this.m_searchResultList.clearSelection(ps);
    }

    public void setListModel(SearchAndListModel model) {
        this.m_listModel = model;
    }

    public void setResultCellRenderer(ListCellRenderer r) {
        this.m_searchResultList.setCellRenderer(r);
    }

    public void register(Page p) {
        p.setVisibleDefault(this.m_searchForm, true);
        p.setVisibleDefault(this.m_searchResultContainer, false);
    }

    public void reset(PageState ps) {
        this.m_searchResultContainer.setVisible(ps, false);
        this.m_searchForm.setVisible(ps, true);
        this.clearSelection(ps);
    }

    private class SearchListModelBuilder
    extends LockableImpl
    implements ListModelBuilder {
        private SearchListModelBuilder() {
        }

        public ListModel makeModel(List l, PageState state) {
            return SearchAndList.this.m_listModel;
        }
    }
}

