/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.ui.admin;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.EmailAddress;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.UserAuthentication;
import com.arsdigita.ui.admin.AdminConstants;
import com.arsdigita.ui.admin.UserBrowsePane;
import com.arsdigita.xml.Element;
import java.util.Iterator;

class UserInfo
extends SimpleComponent
implements AdminConstants {
    private Element m_elmt;
    private UserBrowsePane m_parent;

    public UserInfo(UserBrowsePane parent) {
        this.m_parent = parent;
    }

    public void generateXML(PageState state, Element parent) {
        this.m_elmt = new Element("admin:userInfo", "http://www.arsdigita.com/admin-ui/1.0");
        parent.addContent(this.m_elmt);
        User user = this.m_parent.getUser(state);
        this.m_elmt.addAttribute("id", user.getID().toString());
        this.m_elmt.addAttribute("name", user.getDisplayName());
        this.m_elmt.addAttribute("screenName", user.getScreenName());
        this.m_elmt.addAttribute("URI", user.getURI());
        this.addMemberState(user);
        EmailAddress primary = user.getPrimaryEmail();
        this.addEmail(primary, true);
        Iterator iter = user.getAlternateEmails();
        while (iter.hasNext()) {
            this.addEmail((EmailAddress)iter.next(), false);
        }
    }

    private void addEmail(EmailAddress email, boolean isPrimary) {
        Element elmt = new Element("admin:email", "http://www.arsdigita.com/admin-ui/1.0");
        elmt.addAttribute("address", email.getEmailAddress());
        if (isPrimary) {
            elmt.addAttribute("primary", "t");
        }
        this.m_elmt.addContent(elmt);
    }

    private void addMemberState(User user) {
        String state = "approved";
        try {
            UserAuthentication.retrieveForUser(user);
        }
        catch (DataObjectNotFoundException ex) {
            state = "unauthorized";
        }
        this.m_elmt.addAttribute("memberState", state);
    }
}

