/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.ui.admin;

import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.form.Password;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotEmptyValidationListener;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.UserAuthentication;
import com.arsdigita.mail.Mail;
import com.arsdigita.ui.admin.AdminConstants;
import com.arsdigita.ui.admin.UserBrowsePane;
import com.arsdigita.ui.login.PasswordValidationListener;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import javax.mail.MessagingException;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

class UserPasswordForm
extends Form
implements FormInitListener,
FormProcessListener,
FormValidationListener,
AdminConstants {
    private static final Logger s_log = Logger.getLogger((String)(class$com$arsdigita$ui$admin$UserPasswordForm == null ? (class$com$arsdigita$ui$admin$UserPasswordForm = UserPasswordForm.class$("com.arsdigita.ui.admin.UserPasswordForm")) : class$com$arsdigita$ui$admin$UserPasswordForm).getName());
    static final String PASSWORD_FORM_NAME = "password-update";
    static final String NEW_PASSWORD_PARAM_NAME = "password-new";
    static final String CONFIRM_PASSWORD_PARAM_NAME = "password-confirm";
    private UserBrowsePane m_userBrowsePane;
    private TextField m_question;
    private TextField m_answer;
    static /* synthetic */ Class class$com$arsdigita$ui$admin$UserPasswordForm;

    public UserPasswordForm(UserBrowsePane pane) {
        super(PASSWORD_FORM_NAME);
        this.m_userBrowsePane = pane;
        this.setMethod("post");
        this.addInitListener(this);
        this.addValidationListener(this);
        this.addProcessListener(this);
        Password newPassword = new Password(NEW_PASSWORD_PARAM_NAME);
        newPassword.addValidationListener(new PasswordValidationListener());
        this.add(AdminConstants.PASSWORD_FORM_LABEL_PASSWORD);
        this.add(newPassword);
        Password confirmPassword = new Password(CONFIRM_PASSWORD_PARAM_NAME);
        confirmPassword.addValidationListener(new NotNullValidationListener());
        this.add(AdminConstants.PASSWORD_FORM_LABEL_CONFIRMATION_PASSWORD);
        this.add(confirmPassword);
        this.m_question = new TextField(new StringParameter("question"));
        this.m_question.setSize(50);
        this.m_question.addValidationListener(new NotEmptyValidationListener());
        this.add(AdminConstants.PASSWORD_FORM_LABEL_QUESTION);
        this.add(this.m_question);
        this.m_answer = new TextField(new StringParameter("answer"));
        this.m_answer.setSize(50);
        this.add(AdminConstants.PASSWORD_FORM_LABEL_ANSWER);
        this.add(this.m_answer);
        this.add(new Label(""));
        this.add(new Submit(AdminConstants.PASSWORD_FORM_SUBMIT));
    }

    public void init(FormSectionEvent e) {
        User user;
        PageState state = e.getPageState();
        try {
            user = User.retrieve((BigDecimal)state.getValue(AdminConstants.USER_ID_PARAM));
        }
        catch (DataObjectNotFoundException ex) {
            throw new UncheckedWrapperException(ex);
        }
        try {
            UserAuthentication auth = UserAuthentication.retrieveForUser(user);
            this.m_question.setValue(state, auth.getPasswordQuestion());
        }
        catch (DataObjectNotFoundException ex) {
            this.m_question.setValue(state, "Question");
        }
        this.m_answer.setValue(state, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validate(FormSectionEvent event) throws FormProcessException {
        HttpServletRequest req;
        FormData data;
        PageState state;
        block5: {
            state = event.getPageState();
            data = event.getFormData();
            req = state.getRequest();
            try {
                User user = User.retrieve((BigDecimal)state.getValue(AdminConstants.USER_ID_PARAM));
            }
            catch (DataObjectNotFoundException e) {
                return;
            }
            try {
                String newPassword = (String)data.get(NEW_PASSWORD_PARAM_NAME);
                String confirmPassword = (String)data.get(CONFIRM_PASSWORD_PARAM_NAME);
                if (newPassword.equals(confirmPassword)) break block5;
                data.addError(CONFIRM_PASSWORD_PARAM_NAME, (String)AdminConstants.USER_FORM_ERROR_PASSWORD_NOT_MATCH.localize(req));
                Object var9_9 = null;
                if (data.isValid()) return;
                data.put(NEW_PASSWORD_PARAM_NAME, "");
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (data.isValid()) throw throwable;
                data.put(NEW_PASSWORD_PARAM_NAME, "");
                data.put(CONFIRM_PASSWORD_PARAM_NAME, "");
                throw throwable;
            }
            data.put(CONFIRM_PASSWORD_PARAM_NAME, "");
            return;
        }
        Object var9_10 = null;
        if (!data.isValid()) {
            data.put(NEW_PASSWORD_PARAM_NAME, "");
            data.put(CONFIRM_PASSWORD_PARAM_NAME, "");
        }
        String answer = (String)this.m_answer.getValue(state);
        if (answer == null || answer.length() <= 0 || answer.trim().length() != 0) return;
        data.addError("answer", (String)AdminConstants.USER_FORM_ERROR_ANSWER_NULL.localize(req));
    }

    public void process(FormSectionEvent event) throws FormProcessException {
        UserAuthentication auth;
        User user;
        PageState state = event.getPageState();
        FormData data = event.getFormData();
        BigDecimal id = (BigDecimal)state.getValue(AdminConstants.USER_ID_PARAM);
        try {
            user = User.retrieve(id);
        }
        catch (DataObjectNotFoundException ex) {
            throw new FormProcessException("Failed to retrieve user", ex);
        }
        try {
            auth = UserAuthentication.retrieveForUser(user);
        }
        catch (DataObjectNotFoundException ex) {
            auth = UserAuthentication.createForUser(user);
            s_log.debug((Object)("Created authentication record for " + id));
        }
        auth.setPassword((String)data.get(NEW_PASSWORD_PARAM_NAME));
        auth.setPasswordQuestion((String)this.m_question.getValue(state));
        String answer = (String)this.m_answer.getValue(state);
        if (answer != null && answer.length() > 0) {
            auth.setPasswordAnswer(answer);
        }
        auth.save();
        s_log.debug((Object)"Committed password change");
        this.notifyUser(user);
        this.m_userBrowsePane.displayUserInfoPanel(state);
    }

    private void notifyUser(User user) {
        String to;
        String from = to = user.getPrimaryEmail().toString();
        String subject = "Your password has been changed";
        String nl = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append("Dear ");
        sb.append(user.getPersonName().getGivenName());
        sb.append(":");
        sb.append(nl).append(nl);
        sb.append("Your password has been changed by the ");
        sb.append("system administrator.");
        sb.append(nl);
        try {
            Mail.send(to, from, subject, sb.toString());
        }
        catch (MessagingException e) {
            s_log.error((Object)"Failed to notify user of password change");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

