/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.ui.admin;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Resettable;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.ChangeEvent;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.list.ListCellRenderer;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.ui.admin.AdminConstants;
import com.arsdigita.ui.admin.AdminSplitPanel;
import com.arsdigita.ui.admin.SearchAndList;
import com.arsdigita.ui.admin.UserBrowsePane;
import com.arsdigita.ui.admin.UserSearchAndListModel;
import com.arsdigita.ui.util.GlobalizationUtil;
import java.math.BigDecimal;

class UserSummaryBodyPane
extends BoxPanel
implements AdminConstants,
ChangeListener,
ActionListener,
Resettable {
    private static final String EXCLUDE_GROUP_ID = "excludeGroupId";
    private AdminSplitPanel m_splitPanel;
    private SearchAndList m_searchAndList;
    private UserBrowsePane m_userBrowsePane;

    public UserSummaryBodyPane(AdminSplitPanel panel, UserBrowsePane userBrowsePane) {
        super(2);
        this.m_splitPanel = panel;
        this.m_userBrowsePane = userBrowsePane;
        this.add(this.createTotalUsersLabel());
        this.m_searchAndList = this.makeUserSearch();
        this.add(this.m_searchAndList);
        ActionLink createLink = new ActionLink(AdminConstants.CREATE_USER_LABEL);
        createLink.setClassAttr("actionLink");
        createLink.addActionListener(this);
        this.add(createLink);
    }

    private Component createTotalUsersLabel() {
        BoxPanel p = new BoxPanel(1);
        p.add(AdminConstants.TOTAL_USERS_LABEL);
        Label nResults = new Label(GlobalizationUtil.globalize("ui.admin.nusers"));
        nResults.addPrintListener(new PrintListener(){

            public void prepare(PrintEvent e) {
                DataQuery query = SessionManager.getSession().retrieveQuery("com.arsdigita.kernel.RetrieveUsers");
                query.setParameter(UserSummaryBodyPane.EXCLUDE_GROUP_ID, null);
                long nUsers = query.size();
                Label l = (Label)e.getTarget();
                l.setLabel(Long.toString(nUsers));
            }
        });
        ActionLink nUsersLink = new ActionLink(nResults);
        nUsersLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UserSummaryBodyPane.this.m_splitPanel.setTab(1, e.getPageState());
            }
        });
        p.add(nUsersLink);
        return p;
    }

    public void actionPerformed(ActionEvent e) {
        this.m_splitPanel.setTab(3, e.getPageState());
    }

    private SearchAndList makeUserSearch() {
        SearchAndList s = new SearchAndList("user_search");
        s.addChangeListener(this);
        s.setResultCellRenderer(new ListCellRenderer(){

            public Component getComponent(List list, PageState state, Object value, String key, int index, boolean isSelected) {
                ControlLink userLink = new ControlLink(value.toString());
                return userLink;
            }
        });
        s.setListModel(new UserSearchAndListModel());
        return s;
    }

    public void stateChanged(ChangeEvent e) {
        PageState ps = e.getPageState();
        this.m_splitPanel.setTab(1, e.getPageState());
        String sk = (String)this.m_searchAndList.getSelectedKey(ps);
        if (null != sk) {
            ps.setValue(AdminConstants.USER_ID_PARAM, new BigDecimal(sk));
            this.m_userBrowsePane.displayUserInfoPanel(e.getPageState());
        }
    }

    public void reset(PageState ps) {
        this.m_searchAndList.reset(ps);
    }
}

