/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.ui.login;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ElementComponent;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.EmailParameter;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.KernelHelper;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.UserAuthentication;
import com.arsdigita.kernel.security.CredentialEncodingException;
import com.arsdigita.kernel.security.Initializer;
import com.arsdigita.kernel.security.RecoveryLoginModule;
import com.arsdigita.mail.Mail;
import com.arsdigita.ui.login.EmailInitListener;
import com.arsdigita.ui.login.LoginConstants;
import com.arsdigita.ui.login.LoginHelper;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.ParameterMap;
import com.arsdigita.web.URL;
import java.math.BigDecimal;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class RecoverPasswordPanel
extends SimpleContainer
implements LoginConstants {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/ui/login/RecoverPasswordPanel.java#13 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((String)(class$com$arsdigita$ui$login$RecoverPasswordPanel == null ? (class$com$arsdigita$ui$login$RecoverPasswordPanel = RecoverPasswordPanel.class$("com.arsdigita.ui.login.RecoverPasswordPanel")) : class$com$arsdigita$ui$login$RecoverPasswordPanel).getName());
    private static ParameterModel DISPLAY_PARAM = new StringParameter("display");
    private static ParameterModel USERID_PARAM = new BigDecimalParameter("userID");
    private EnterEmailForm m_enterEmailForm = new EnterEmailForm();
    private AnswerQuestionForm m_answerQuestionForm;
    private MailSentPane m_mailSentPane;
    private MailFailedPane m_mailFailedPane;
    static /* synthetic */ Class class$com$arsdigita$ui$login$RecoverPasswordPanel;
    static /* synthetic */ Class class$com$arsdigita$ui$login$RecoverPasswordPanel$AnswerQuestionForm;
    static /* synthetic */ Class class$com$arsdigita$ui$login$RecoverPasswordPanel$MailSentPane;
    static /* synthetic */ Class class$com$arsdigita$ui$login$RecoverPasswordPanel$MailFailedPane;

    public void register(Page p) {
        super.register(p);
        p.addComponentStateParam(this, DISPLAY_PARAM);
        p.addComponentStateParam(this, USERID_PARAM);
        p.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState state = e.getPageState();
                String display = (String)state.getValue(DISPLAY_PARAM);
                s_log.debug((Object)("display == " + display));
                boolean visible = false;
                visible |= this.setVisible(state, display, RecoverPasswordPanel.this.m_enterEmailForm);
                visible |= this.setVisible(state, display, RecoverPasswordPanel.this.m_answerQuestionForm);
                visible |= this.setVisible(state, display, RecoverPasswordPanel.this.m_mailSentPane);
                if (!(visible |= this.setVisible(state, display, RecoverPasswordPanel.this.m_mailFailedPane))) {
                    RecoverPasswordPanel.this.m_enterEmailForm.setVisible(state, true);
                }
            }

            private boolean setVisible(PageState state, String display, Component component) {
                boolean visible = component.getClass().getName().equals(display);
                component.setVisible(state, visible);
                return visible;
            }
        });
    }

    public RecoverPasswordPanel() {
        this.add(this.m_enterEmailForm);
        this.m_answerQuestionForm = new AnswerQuestionForm();
        this.add(this.m_answerQuestionForm);
        this.m_mailSentPane = new MailSentPane();
        this.add(this.m_mailSentPane);
        this.m_mailFailedPane = new MailFailedPane();
        this.add(this.m_mailFailedPane);
    }

    private static void mailFailed(FormSectionEvent event, String reason) {
        s_log.debug((Object)("Could not notify user for recovery: " + reason));
        event.getPageState().setValue(DISPLAY_PARAM, (class$com$arsdigita$ui$login$RecoverPasswordPanel$MailFailedPane == null ? (class$com$arsdigita$ui$login$RecoverPasswordPanel$MailFailedPane = RecoverPasswordPanel.class$("com.arsdigita.ui.login.RecoverPasswordPanel$MailFailedPane")) : class$com$arsdigita$ui$login$RecoverPasswordPanel$MailFailedPane).getName());
    }

    private static String getNotification(User user, FormSectionEvent event, HttpServletRequest req) {
        URL url;
        String name = user.getPersonName().getGivenName();
        try {
            ParameterMap map = new ParameterMap();
            map.setParameter(RecoveryLoginModule.getParamName(), RecoveryLoginModule.getParamValue(user.getID()));
            url = URL.there(req, Initializer.getFullURL(Initializer.CHANGE_PAGE_KEY, req), map);
        }
        catch (CredentialEncodingException e) {
            throw new UncheckedWrapperException("Could not create URL", e);
        }
        return LoginHelper.localize("login.recoverPassword.mailBody", new Object[]{name, url.getURL()}, req);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class MailFailedPane
    extends ElementComponent {
        public MailFailedPane() {
            super("subsite:recoverPasswordMailFailed", "http://www.arsdigita.com/subsite/1.0");
        }
    }

    private static class MailSentPane
    extends ElementComponent {
        public MailSentPane() {
            super("subsite:recoverPasswordMailSent", "http://www.arsdigita.com/subsite/1.0");
        }
    }

    private static class AnswerQuestionForm
    extends Form
    implements FormValidationListener,
    FormProcessListener {
        private TextField m_answer;

        public AnswerQuestionForm() {
            super("answer-question", new BoxPanel());
            this.addValidationListener(this);
            this.addProcessListener(this);
            this.add(new Label(LoginConstants.PASSWORD_QUESTION));
            Label question = new Label();
            question.addPrintListener(new PrintListener(this){
                private final /* synthetic */ AnswerQuestionForm this$0;
                {
                    this.this$0 = this$0;
                }

                public void prepare(PrintEvent event) {
                    Label label = (Label)event.getTarget();
                    BigDecimal userID = (BigDecimal)event.getPageState().getValue(RecoverPasswordPanel.access$600());
                    if (userID == null) {
                        throw new IllegalStateException("userID must not be null");
                    }
                    try {
                        String theQuestion = UserAuthentication.retrieveForUser(userID).getPasswordQuestion();
                        if (theQuestion == null) {
                            throw new IllegalStateException("password question must not be null (userID == " + userID + ")");
                        }
                        label.setLabel(theQuestion);
                    }
                    catch (DataObjectNotFoundException e) {
                        throw new IllegalStateException("userID must be a valid user");
                    }
                }
            });
            this.add(question);
            this.add(new Label(LoginConstants.PASSWORD_ANSWER));
            this.m_answer = new TextField(new StringParameter("answer"));
            this.m_answer.addValidationListener(new NotNullValidationListener());
            this.add(this.m_answer);
            this.add(new Submit(LoginConstants.SUBMIT));
        }

        public void validate(FormSectionEvent event) throws FormProcessException {
            FormData data = event.getFormData();
            if (!data.isValid()) {
                return;
            }
            String answer = (String)data.get("answer");
            BigDecimal userID = (BigDecimal)event.getPageState().getValue(USERID_PARAM);
            if (userID == null) {
                throw new IllegalStateException("userID must not be null");
            }
            try {
                if (!UserAuthentication.retrieveForUser(userID).isValidAnswer(answer)) {
                    data.addError("answer", (String)LoginConstants.ERROR_BAD_ANSWER.localize(event.getPageState().getRequest()));
                }
            }
            catch (DataObjectNotFoundException e) {
                throw new IllegalStateException("userID must be a valid user");
            }
        }

        public void process(FormSectionEvent event) throws FormProcessException {
            User user;
            HttpServletRequest req = event.getPageState().getRequest();
            BigDecimal userID = (BigDecimal)event.getPageState().getValue(USERID_PARAM);
            if (userID == null) {
                throw new IllegalStateException("userID must not be null");
            }
            try {
                user = UserAuthentication.retrieveForUser(userID).getUser();
            }
            catch (DataObjectNotFoundException e) {
                throw new IllegalStateException("userID must be a valid user");
            }
            if (user.getPrimaryEmail() == null) {
                RecoverPasswordPanel.mailFailed(event, "null email, user ID: " + user.getID());
                return;
            }
            String to = user.getPrimaryEmail().toString();
            String from = KernelHelper.getSystemAdministratorEmailAddress();
            String subject = LoginHelper.localize("login.recoverPassword.mailSubject", req);
            String body = RecoverPasswordPanel.getNotification(user, event, req);
            try {
                Mail.send(to, from, subject, body);
                event.getPageState().setValue(DISPLAY_PARAM, (class$com$arsdigita$ui$login$RecoverPasswordPanel$MailSentPane == null ? (class$com$arsdigita$ui$login$RecoverPasswordPanel$MailSentPane = RecoverPasswordPanel.class$("com.arsdigita.ui.login.RecoverPasswordPanel$MailSentPane")) : class$com$arsdigita$ui$login$RecoverPasswordPanel$MailSentPane).getName());
            }
            catch (MessagingException e) {
                RecoverPasswordPanel.mailFailed(event, e.toString());
            }
        }
    }

    private static class EnterEmailForm
    extends Form
    implements FormValidationListener,
    FormProcessListener {
        public EnterEmailForm() {
            super("enter-email", new BoxPanel());
            this.addValidationListener(this);
            this.addProcessListener(this);
            this.add(new Label(LoginConstants.PRIMARY_EMAIL));
            TextField email = new TextField(new EmailParameter("emailAddress"));
            email.addValidationListener(new NotNullValidationListener());
            this.addInitListener(new EmailInitListener((EmailParameter)email.getParameterModel()));
            this.add(email);
            this.add(new Submit(LoginConstants.SUBMIT));
        }

        public void validate(FormSectionEvent event) throws FormProcessException {
            FormData data = event.getFormData();
            if (!data.isValid()) {
                return;
            }
            String email = ((InternetAddress)data.get("emailAddress")).getAddress();
            try {
                UserAuthentication auth = UserAuthentication.retrieveForLoginName(email);
                BigDecimal userID = auth.getUser().getID();
                event.getPageState().setValue(USERID_PARAM, userID);
            }
            catch (DataObjectNotFoundException e) {
                data.addError("emailAddress", (String)LoginConstants.ERROR_BAD_EMAIL.localize(event.getPageState().getRequest()));
            }
        }

        public void process(FormSectionEvent event) throws FormProcessException {
            event.getPageState().setValue(DISPLAY_PARAM, (class$com$arsdigita$ui$login$RecoverPasswordPanel$AnswerQuestionForm == null ? (class$com$arsdigita$ui$login$RecoverPasswordPanel$AnswerQuestionForm = RecoverPasswordPanel.class$("com.arsdigita.ui.login.RecoverPasswordPanel$AnswerQuestionForm")) : class$com$arsdigita$ui$login$RecoverPasswordPanel$AnswerQuestionForm).getName());
        }
    }
}

