/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.ui.login;

import com.arsdigita.bebop.ListPanel;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.kernel.PackageInstance;
import com.arsdigita.kernel.PackageInstanceCollection;
import com.arsdigita.kernel.PackageType;
import com.arsdigita.kernel.SiteNode;
import com.arsdigita.kernel.SiteNodeCollection;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.security.Initializer;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.ui.login.DynamicLink;
import com.arsdigita.ui.login.UserAuthenticationListener;
import com.arsdigita.web.URL;
import com.arsdigita.xml.Element;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class UserInfo
extends SimpleContainer {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/ui/login/UserInfo.java#13 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((String)(class$com$arsdigita$ui$login$UserInfo == null ? (class$com$arsdigita$ui$login$UserInfo = UserInfo.class$("com.arsdigita.ui.login.UserInfo")) : class$com$arsdigita$ui$login$UserInfo).getName());
    private List m_contentCenters;
    private HashMap m_centerSiteNodes;
    private UserAuthenticationListener m_listener = new UserAuthenticationListener();
    static /* synthetic */ Class class$com$arsdigita$ui$login$UserInfo;

    public UserInfo() {
        ListPanel list = new ListPanel(false);
        list.add(new DynamicLink("login.userInfo.logoutLink", Initializer.LOGOUT_PAGE_KEY));
        list.add(new DynamicLink("login.userInfo.editProfileLink", Initializer.EDIT_PAGE_KEY));
        list.add(new DynamicLink("login.userInfo.changePasswordLink", Initializer.CHANGE_PAGE_KEY));
        this.add(list);
        this.add(new SimpleComponent(){

            public void generateXML(PageState state, Element parent) {
                if (!UserInfo.this.isLoggedIn(state)) {
                    s_log.debug((Object)"user is not logged in, so no XML generated");
                    return;
                }
                User user = UserInfo.this.getUser(state);
                Element userElement = new Element("subsite:userInfo", "http://www.arsdigita.com/subsite/1.0");
                if (UserInfo.this.m_contentCenters == null) {
                    UserInfo.this.m_contentCenters = new ArrayList();
                    UserInfo.this.m_centerSiteNodes = new HashMap();
                    DataCollection dc = SessionManager.getSession().retrieve("com.arsdigita.kernel.PackageType");
                    dc.addEqualsFilter("packageKey", "content-center");
                    if (dc.next()) {
                        PackageType pt = new PackageType(dc.getDataObject());
                        dc.close();
                        PackageInstanceCollection collection = pt.getInstances();
                        while (collection.next()) {
                            PackageInstance instance = collection.getPackageInstance();
                            instance.disconnect();
                            UserInfo.this.m_contentCenters.add(instance);
                            SiteNodeCollection nodes = instance.getMountPoints();
                            ArrayList<SiteNode> list = new ArrayList<SiteNode>();
                            while (nodes.next()) {
                                SiteNode sn = nodes.getSiteNode();
                                sn.disconnect();
                                list.add(sn);
                            }
                            UserInfo.this.m_centerSiteNodes.put(instance, list);
                        }
                    }
                }
                if (UserInfo.this.m_contentCenters.size() > 0) {
                    Element contentCenters = userElement.newChildElement("subsite:contentCenters", "http://www.arsdigita.com/subsite/1.0");
                    Iterator centers = UserInfo.this.m_contentCenters.iterator();
                    while (centers.hasNext()) {
                        PackageInstance instance = (PackageInstance)centers.next();
                        Element center = contentCenters.newChildElement("subsite:center", "http://www.arsdigita.com/subsite/1.0");
                        center.addAttribute("name", instance.getName());
                        List nodes = (List)UserInfo.this.m_centerSiteNodes.get(instance);
                        if (nodes == null) continue;
                        Iterator nodesIterator = nodes.iterator();
                        while (nodesIterator.hasNext()) {
                            SiteNode node = (SiteNode)nodesIterator.next();
                            Element nodeURL = center.newChildElement("subsite:url", "http://www.arsdigita.com/subsite/1.0");
                            URL url = URL.there(state.getRequest(), node.getURL());
                            nodeURL.setText(url.toString());
                        }
                    }
                }
                userElement.addAttribute("id", user.getID().toString());
                userElement.addAttribute("email", user.getPrimaryEmail().getEmailAddress());
                userElement.addAttribute("name", user.getName());
                userElement.addAttribute("screenName", user.getScreenName());
                userElement.addAttribute("URI", user.getURI());
                parent.addContent(userElement);
            }
        });
    }

    public void register(Page p) {
        super.register(p);
        p.addRequestListener(this.m_listener);
    }

    protected boolean isLoggedIn(PageState state) {
        return this.m_listener.isLoggedIn(state);
    }

    protected User getUser(PageState state) {
        if (!this.isLoggedIn(state)) {
            throw new IllegalStateException("user is not logged in");
        }
        return this.m_listener.getUser(state);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

