/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.ui.login;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.ElementComponent;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.form.CheckboxGroup;
import com.arsdigita.bebop.form.Hidden;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.Password;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.EmailParameter;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.bebop.parameters.URLParameter;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelHelper;
import com.arsdigita.kernel.security.AccountNotFoundException;
import com.arsdigita.kernel.security.Credential;
import com.arsdigita.kernel.security.CredentialException;
import com.arsdigita.kernel.security.Initializer;
import com.arsdigita.kernel.security.UserContext;
import com.arsdigita.ui.login.DynamicLink;
import com.arsdigita.ui.login.EmailInitListener;
import com.arsdigita.ui.login.LoginConstants;
import com.arsdigita.ui.login.LoginHelper;
import com.arsdigita.ui.login.ScreenNameInitListener;
import com.arsdigita.web.ParameterMap;
import com.arsdigita.web.RedirectSignal;
import com.arsdigita.web.ReturnSignal;
import com.arsdigita.web.URL;
import com.arsdigita.web.Web;
import javax.mail.internet.InternetAddress;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class UserRegistrationForm
extends Form
implements LoginConstants,
FormInitListener,
FormValidationListener,
FormProcessListener {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/ui/login/UserRegistrationForm.java#26 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$ui$login$UserRegistrationForm == null ? (class$com$arsdigita$ui$login$UserRegistrationForm = UserRegistrationForm.class$("com.arsdigita.ui.login.UserRegistrationForm")) : class$com$arsdigita$ui$login$UserRegistrationForm));
    static final String FORM_NAME = "user-login";
    private CheckboxGroup m_isPersistent;
    private Hidden m_timestamp;
    private Hidden m_returnURL;
    private TextField m_loginName;
    private Password m_password;
    private boolean m_autoRegistrationOn;
    static /* synthetic */ Class class$com$arsdigita$ui$login$UserRegistrationForm;

    public UserRegistrationForm() {
        this(true);
    }

    public UserRegistrationForm(Container panel) {
        this(panel, true);
    }

    public UserRegistrationForm(boolean autoRegistrationOn) {
        this((Container)new BoxPanel(), autoRegistrationOn);
    }

    public UserRegistrationForm(Container panel, boolean autoRegistrationOn) {
        super(FORM_NAME, panel);
        this.setMethod("post");
        this.addInitListener(this);
        this.addValidationListener(this);
        this.addProcessListener(this);
        this.m_autoRegistrationOn = autoRegistrationOn;
        this.m_timestamp = new Hidden(new StringParameter("timestamp"));
        this.add(this.m_timestamp);
        this.m_returnURL = new Hidden(new URLParameter("return_url"));
        this.m_returnURL.setPassIn(true);
        this.add(this.m_returnURL);
        this.setupLogin();
        this.add(new Label(LoginHelper.getMessage("login.userRegistrationForm.password")));
        this.m_password = new Password(new StringParameter("password"));
        this.add(this.m_password);
        BoxPanel cookiePanel = new BoxPanel(1);
        this.m_isPersistent = new CheckboxGroup("persistentCookieP");
        Label optLabel = new Label(LoginHelper.getMessage("login.userRegistrationForm.cookieOption"));
        Option opt = new Option("1", optLabel);
        this.m_isPersistent.addOption(opt);
        if (Kernel.getConfig().isLoginRemembered()) {
            this.m_isPersistent.setOptionSelected("1");
        }
        cookiePanel.add(this.m_isPersistent);
        cookiePanel.add(new DynamicLink("login.userRegistrationForm.explainCookieLink", Initializer.COOKIES_PAGE_KEY));
        this.add(cookiePanel);
        this.add(new Submit(LoginConstants.SUBMIT), 66);
        this.add(new DynamicLink("login.userRegistrationForm.forgotPasswordLink", Initializer.RECOVER_PAGE_KEY));
        if (this.m_autoRegistrationOn) {
            this.add(new DynamicLink("login.userRegistrationForm.newUserRegister", Initializer.NEWUSER_PAGE_KEY));
        }
        this.add(new ElementComponent("subsite:promptToEnableCookiesMsg", "http://www.arsdigita.com/subsite/1.0"));
    }

    private void setupLogin() {
        SimpleContainer loginMessage = new SimpleContainer("subsite:loginPromptMsg", "http://www.arsdigita.com/subsite/1.0");
        if (KernelHelper.emailIsPrimaryIdentifier()) {
            loginMessage.setClassAttr("email");
        } else {
            loginMessage.setClassAttr("screenName");
        }
        this.add(loginMessage);
        if (KernelHelper.emailIsPrimaryIdentifier()) {
            this.add(new Label(LoginHelper.getMessage("login.userRegistrationForm.email")));
            this.m_loginName = new TextField(new EmailParameter("email"));
            this.addInitListener(new EmailInitListener((EmailParameter)this.m_loginName.getParameterModel()));
        } else {
            this.add(new Label(LoginHelper.getMessage("login.userRegistrationForm.screenName")));
            this.m_loginName = new TextField(new StringParameter("email"));
            this.addInitListener(new ScreenNameInitListener((StringParameter)this.m_loginName.getParameterModel()));
        }
        this.m_loginName.addValidationListener(new NotNullValidationListener());
        this.add(this.m_loginName);
    }

    public void init(FormSectionEvent event) throws FormProcessException {
        try {
            String value = Credential.create("timestamp", 300000L).toString();
            this.m_timestamp.setValue(event.getPageState(), value);
        }
        catch (CredentialException e) {
            s_log.debug((Object)"Could not create timestamp", (Throwable)e);
            throw new FormProcessException("Could not create timestamp", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validate(FormSectionEvent event) throws FormProcessException {
        FormData data = event.getFormData();
        PageState state = event.getPageState();
        try {
            try {
                Credential.parse((String)this.m_timestamp.getValue(state));
            }
            catch (CredentialException e) {
                String path = Initializer.getFullURL(Initializer.EXPIRED_PAGE_KEY, state.getRequest());
                URL url = URL.there(state.getRequest(), path);
                throw new RedirectSignal(url, false);
            }
            if (this.m_loginName.getValue(state) != null) {
                this.loginUser(event);
            }
            Object var8_7 = null;
            if (data.isValid()) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (data.isValid()) throw throwable;
            this.m_password.setValue(state, "");
            throw throwable;
        }
        this.m_password.setValue(state, "");
    }

    public void process(FormSectionEvent event) throws FormProcessException {
        PageState state = event.getPageState();
        HttpServletRequest req = state.getRequest();
        String path = Initializer.getFullURL(Initializer.LOGIN_REDIRECT_PAGE_KEY, req);
        URL url = URL.there(req, path);
        throw new ReturnSignal(req, url);
    }

    protected void loginUser(FormSectionEvent event) throws FormProcessException {
        PageState state = event.getPageState();
        try {
            UserContext ctx = Web.getUserContext();
            String username = null;
            username = KernelHelper.emailIsPrimaryIdentifier() ? ((InternetAddress)this.m_loginName.getValue(state)).getAddress() : (String)this.m_loginName.getValue(state);
            char[] password = ((String)this.m_password.getValue(state)).trim().toCharArray();
            boolean forever = this.getPersistentLoginValue(event.getPageState(), false);
            ctx.login(username, password, forever);
            this.onLoginSuccess(event);
        }
        catch (FailedLoginException e) {
            this.onLoginFail(event, e);
        }
        catch (AccountNotFoundException e) {
            if (this.m_autoRegistrationOn) {
                this.onAccountNotFound(event, e);
            } else {
                this.onLoginFail(event, e);
            }
        }
        catch (LoginException e) {
            this.onLoginException(event, e);
        }
    }

    protected void onLoginSuccess(FormSectionEvent event) throws FormProcessException {
    }

    protected void onBadPassword(FormSectionEvent event, FailedLoginException e) throws FormProcessException {
        this.onLoginFail(event, e);
    }

    protected void onLoginFail(FormSectionEvent event, LoginException e) throws FormProcessException {
        s_log.debug((Object)"Login fail");
        event.getFormData().addError((String)LoginConstants.ERROR_LOGIN_FAIL.localize(event.getPageState().getRequest()));
    }

    protected void onAccountNotFound(FormSectionEvent event, AccountNotFoundException e) throws FormProcessException {
        PageState state = event.getPageState();
        s_log.debug((Object)("Account not found: " + this.m_autoRegistrationOn));
        if (this.m_autoRegistrationOn) {
            s_log.debug((Object)"autoRegOn");
            this.redirectToNewUserPage(state);
        } else {
            s_log.debug((Object)"About to goto loginFail");
            this.onLoginFail(event, e);
        }
    }

    protected void onLoginException(FormSectionEvent event, LoginException e) throws FormProcessException {
        s_log.error((Object)"Login failed", (Throwable)e);
        throw new FormProcessException(e);
    }

    protected boolean getPersistentLoginValue(PageState state, boolean defaultValue) {
        String[] values = (String[])this.m_isPersistent.getValue(state);
        if (values == null) {
            return defaultValue;
        }
        String persistentLoginValue = values[0];
        return "1".equals(persistentLoginValue);
    }

    protected void redirectToNewUserPage(PageState state) {
        String url = Initializer.getFullURL(Initializer.NEWUSER_PAGE_KEY, state.getRequest());
        ParameterMap map = new ParameterMap();
        map.setParameter("return_url", this.m_returnURL.getValue(state));
        map.setParameter("persistentCookieP", this.m_isPersistent.getValue(state));
        map.setParameter("emailAddress", this.m_loginName.getValue(state));
        URL dest = URL.there(state.getRequest(), url, map);
        throw new RedirectSignal(dest, true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

