/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.ui.permissions;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.DimensionalNavbar;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SegmentedPanel;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.list.ListCellRenderer;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.kernel.security.Initializer;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.ui.permissions.PermissionsConstants;
import com.arsdigita.ui.permissions.UserObjectStruct;
import com.arsdigita.util.LockableImpl;
import java.math.BigDecimal;

class IndexPanel
extends SimpleContainer
implements PermissionsConstants {
    private static final String OBJECT_QUERY = "com.arsdigita.ui.permissions.PermissionObjects";
    private static final String ACSOBJECT_ID = "objectID";
    private SegmentedPanel m_segmentedPanel;
    private List m_adminObjs;
    private Label m_listHeader;
    private DimensionalNavbar m_navbar;

    public IndexPanel() {
        this.setClassAttr("PERMISSIONS");
        this.m_navbar = new DimensionalNavbar();
        this.m_navbar.add(new Link(PermissionsConstants.PERSONAL_SITE.localize() + "", "/" + Initializer.getURL(Initializer.WORKSPACE_PAGE_KEY)));
        this.m_navbar.add(new Link(PermissionsConstants.MAIN_SITE.localize() + "", "/"));
        this.m_navbar.add(new Label(PermissionsConstants.PERMISSIONS_INDEX_NAVBAR.localize() + ""));
        this.m_navbar.setClassAttr("permNavBar");
        this.add(this.m_navbar);
        this.m_listHeader = new Label(PermissionsConstants.PAGE_OBJECT_INDEX);
        this.m_adminObjs = new List(new AdminObjectsPermListBuilder());
        this.m_adminObjs.setCellRenderer(new ListObjectLinkRenderer());
        this.m_adminObjs.setClassAttr("bulletList");
        BoxPanel boxpanel = new BoxPanel();
        boxpanel.add(this.m_listHeader);
        boxpanel.add(this.m_adminObjs);
        this.m_segmentedPanel = new SegmentedPanel();
        this.m_segmentedPanel.addSegment(new Label(PermissionsConstants.PAGE_OBJECT_PANEL_TITLE.localize() + ""), (Component)boxpanel);
        this.add(this.m_segmentedPanel);
    }

    private final class ListObjectLinkRenderer
    implements ListCellRenderer {
        private ListObjectLinkRenderer() {
        }

        public Component getComponent(List list, PageState state, Object value, String key, int index, boolean isSelected) {
            Link link = new Link((String)value, "/permissions/one?po_id=" + key);
            return link;
        }
    }

    private class AdminObjectsPermListModel
    implements ListModel {
        private DataQuery m_query;
        private BigDecimal m_id;
        private ACSObject m_object;

        AdminObjectsPermListModel(DataQuery query) {
            this.m_query = query;
        }

        public boolean next() {
            if (this.m_query.next()) {
                this.m_id = (BigDecimal)this.m_query.get(IndexPanel.ACSOBJECT_ID);
                this.m_object = UserObjectStruct.loadObject(this.m_id);
                return true;
            }
            this.m_query.close();
            return false;
        }

        public String getKey() {
            return this.m_object.getID().toString();
        }

        public Object getElement() {
            return this.m_object.getDisplayName();
        }
    }

    private class AdminObjectsPermListBuilder
    extends LockableImpl
    implements ListModelBuilder {
        private AdminObjectsPermListBuilder() {
        }

        public ListModel makeModel(List l, PageState s) {
            Party party = Kernel.getContext().getParty();
            DataQuery query = SessionManager.getSession().retrieveQuery(IndexPanel.OBJECT_QUERY);
            PermissionService.filterQuery(query, IndexPanel.ACSOBJECT_ID, PrivilegeDescriptor.ADMIN, party.getOID());
            return new AdminObjectsPermListModel(query);
        }
    }
}

