/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.ui.sitemap;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.ToggleLink;
import com.arsdigita.bebop.Tree;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.ChangeEvent;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.tree.TreeModel;
import com.arsdigita.bebop.tree.TreeModelBuilder;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.SiteNode;
import com.arsdigita.ui.sitemap.SiteNodeTreeModel;
import com.arsdigita.ui.util.GlobalizationUtil;
import com.arsdigita.util.LockableImpl;
import org.apache.log4j.Logger;

public class SiteListing
extends BoxPanel
implements ChangeListener,
ActionListener {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/ui/sitemap/SiteListing.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$ui$sitemap$SiteListing == null ? (class$com$arsdigita$ui$sitemap$SiteListing = SiteListing.class$("com.arsdigita.ui.sitemap.SiteListing")) : class$com$arsdigita$ui$sitemap$SiteListing));
    private List m_list;
    private Tree m_tree;
    private ToggleLink m_addLink;
    static /* synthetic */ Class class$com$arsdigita$ui$sitemap$SiteListing;

    public SiteListing() {
        super(2, false);
        try {
            SiteNode sn = SiteNode.getSiteNode("/");
            this.m_tree = new Tree(new SitemapTreeModelBuilder());
            this.add(new Label(GlobalizationUtil.globalize("ui.sitemap.h4sitemap_treeh4"), false));
            this.add(this.m_tree);
            this.m_tree.addChangeListener(this);
        }
        catch (DataObjectNotFoundException e) {
            s_log.warn((Object)"Problem Creating Site Map Tree");
            e.printStackTrace();
        }
        this.m_addLink = new ToggleLink(new Label(GlobalizationUtil.globalize("ui.sitemap.configure_sitemap_admin_page")));
        this.add(this.m_addLink);
        Label l = new Label(GlobalizationUtil.globalize("ui.sitemap.configure_sitemap_admin_page"));
        l.setFontWeight("b");
        this.m_addLink.setSelectedComponent(l);
        this.m_addLink.addActionListener(this);
    }

    public List getList() {
        return this.m_list;
    }

    public Tree getTree() {
        return this.m_tree;
    }

    public ToggleLink getCFGLink() {
        return this.m_addLink;
    }

    public void stateChanged(ChangeEvent e) {
        PageState s = e.getPageState();
        if (this.m_tree.isSelected(s)) {
            this.m_addLink.setSelected(s, false);
        }
    }

    public void actionPerformed(ActionEvent e) {
        PageState s = e.getPageState();
        if (this.m_addLink.isSelected(s)) {
            this.m_tree.clearSelection(s);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class SitemapTreeModelBuilder
    extends LockableImpl
    implements TreeModelBuilder {
        private SitemapTreeModelBuilder() {
        }

        public TreeModel makeModel(Tree t, PageState s) {
            return new SiteNodeTreeModel(SiteNode.getRootSiteNode());
        }
    }
}

