/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.util;

import com.arsdigita.util.AssertionError;
import com.arsdigita.util.Lockable;
import org.apache.log4j.Logger;

public class Assert {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/util/Assert.java#22 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$util$Assert == null ? (class$com$arsdigita$util$Assert = Assert.class$("com.arsdigita.util.Assert")) : class$com$arsdigita$util$Assert));
    private static final String DEFAULT_MESSAGE = "Assertion failure";
    private static boolean s_enabled;
    public static final boolean ASSERT_ON = true;
    static /* synthetic */ Class class$com$arsdigita$util$Assert;

    public static final boolean isEnabled() {
        return s_enabled;
    }

    static final void setEnabled(boolean enabled) {
        s_enabled = enabled;
    }

    public static final void fail(String message) {
        Assert.error(message);
        throw new AssertionError(message);
    }

    public static final void fail() {
        Assert.error(DEFAULT_MESSAGE);
        throw new AssertionError(DEFAULT_MESSAGE);
    }

    public static final void truth(boolean condition, String message) {
        if (!condition) {
            Assert.error(message);
            throw new AssertionError(message);
        }
    }

    public static final void truth(boolean condition) {
        if (!condition) {
            Assert.error(DEFAULT_MESSAGE);
            throw new AssertionError(DEFAULT_MESSAGE);
        }
    }

    public static final void falsity(boolean condition, String message) {
        if (condition) {
            Assert.error(message);
            throw new AssertionError(message);
        }
    }

    public static final void falsity(boolean condition) {
        if (condition) {
            Assert.error(DEFAULT_MESSAGE);
            throw new AssertionError(DEFAULT_MESSAGE);
        }
    }

    public static final void exists(Object object, Class clacc) {
        if (object == null) {
            String message = clacc.getName() + " is null";
            Assert.error(message);
            throw new AssertionError(message);
        }
    }

    public static final void exists(Object object) {
        if (object == null) {
            Assert.error(DEFAULT_MESSAGE);
            throw new AssertionError(DEFAULT_MESSAGE);
        }
    }

    public static final void locked(Lockable lockable) {
        if (lockable != null && !lockable.isLocked()) {
            String message = lockable + " is not locked";
            Assert.error(message);
            throw new AssertionError(message);
        }
    }

    public static final void unlocked(Lockable lockable) {
        if (lockable != null && lockable.isLocked()) {
            String message = lockable + " is locked";
            Assert.error(message);
            throw new AssertionError(message);
        }
    }

    public static final void equal(Object value1, Object value2) {
        if (value1 == null) {
            if (value1 != value2) {
                String message = value1 + " does not equal " + value2;
                Assert.error(message);
                throw new AssertionError(message);
            }
        } else if (!value1.equals(value2)) {
            String message = value1 + " does not equal " + value2;
            Assert.error(message);
            throw new AssertionError(message);
        }
    }

    public static final void equal(Object value1, Object value2, String message) {
        if (value1 == null) {
            if (value1 != value2) {
                Assert.error(message);
                throw new AssertionError(message);
            }
        } else if (!value1.equals(value2)) {
            Assert.error(message);
            throw new AssertionError(message);
        }
    }

    public static final void unequal(Object value1, Object value2) {
        if (value1 == null) {
            if (value1 == value2) {
                String message = value1 + " equals " + value2;
                Assert.error(message);
                throw new AssertionError(message);
            }
        } else if (value1.equals(value2)) {
            String message = value1 + " equals " + value2;
            Assert.error(message);
            throw new AssertionError(message);
        }
    }

    public static final boolean isAssertOn() {
        return Assert.isEnabled();
    }

    public static final boolean isAssertEnabled() {
        return Assert.isEnabled();
    }

    public static final void assertTrue(boolean cond) {
        Assert.assertTrue(cond, "");
    }

    public static final void assertTrue(boolean cond, String msg) {
        if (!cond) {
            Assert.error(msg);
            throw new IllegalStateException(msg);
        }
    }

    public static final void assertNotNull(Object o) {
        Assert.assertNotNull(o, "");
    }

    public static final void assertNotNull(Object o, String label) {
        if (Assert.isEnabled()) {
            Assert.assertTrue(o != null, "Value of " + label + " is null.");
        }
    }

    public static final void assertNotEmpty(String s) {
        Assert.assertNotEmpty(s, "");
    }

    public static final void assertNotEmpty(String s, String label) {
        if (Assert.isEnabled()) {
            Assert.assertTrue(s != null && s.trim().length() > 0, "Value of " + label + " is empty.");
        }
    }

    public static final void assertEquals(Object expected, Object actual) {
        Assert.assertEquals(expected, actual, "expected", "actual");
    }

    public static final void assertEquals(Object expected, Object actual, String expectedLabel, String actualLabel) {
        if (Assert.isEnabled()) {
            if (expected == null) {
                Assert.assertTrue(expected == actual, "Values not equal, " + expectedLabel + " '" + expected + "', " + actualLabel + " '" + actual + "'");
            } else {
                Assert.assertTrue(expected.equals(actual), "Values not equal, " + expectedLabel + " '" + expected + "', " + actualLabel + " '" + actual + "'");
            }
        }
    }

    public static final void assertEquals(int expected, int actual) {
        Assert.assertEquals(expected, actual, "expected", "actual");
    }

    public static final void assertEquals(int expected, int actual, String expectedLabel, String actualLabel) {
        if (Assert.isEnabled()) {
            Assert.assertTrue(expected == actual, "Values not equal, " + expectedLabel + " '" + expected + "', " + actualLabel + " '" + actual + "'");
        }
    }

    public static void assertLocked(Lockable l) {
        if (Assert.isEnabled()) {
            Assert.assertTrue(l.isLocked(), "Illegal access to an unlocked " + l.getClass().getName());
        }
    }

    public static void assertNotLocked(Lockable l) {
        if (Assert.isEnabled()) {
            Assert.assertTrue(!l.isLocked(), "Illegal access to a locked " + l.getClass().getName());
        }
    }

    private static void error(String message) {
        s_log.error((Object)message, (Throwable)new AssertionError(message));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        String enabled = System.getProperty((class$com$arsdigita$util$Assert == null ? (class$com$arsdigita$util$Assert = Assert.class$("com.arsdigita.util.Assert")) : class$com$arsdigita$util$Assert).getName() + ".enabled");
        s_enabled = enabled == null ? true : enabled.equals("true");
    }
}

