/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.util;

import com.arsdigita.util.Assert;
import com.arsdigita.util.Graph;
import com.arsdigita.util.GraphFormatter;
import com.arsdigita.util.GraphSet;
import com.arsdigita.util.Tree;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public class Graphs {
    public static final EdgeSelector FORWARD_SELECTOR = new EdgeSelector(){

        public boolean test(Graph.Edge edge, boolean forward) {
            return forward;
        }
    };
    private static final String INDENT = "    ";

    private Graphs() {
    }

    public static final List findPath(Graph graph, Object begin, Object end) {
        EqualityTerminator terminator = new EqualityTerminator(end);
        return Graphs.findPath(graph, begin, FORWARD_SELECTOR, terminator);
    }

    public static List findPath(Graph graph, Object startNode, EdgeSelector selector, NodeSelector terminator) {
        Stack path = new Stack();
        Graphs.findPathRecur(graph, startNode, selector, terminator, new HashSet(), path);
        return path;
    }

    private static final boolean findPathRecur(Graph graph, Object start, EdgeSelector selector, NodeSelector terminator, Set searched, Stack path) {
        Iterator it = graph.getOutgoingEdges(start).iterator();
        searched.add(start);
        while (it.hasNext()) {
            boolean found;
            Graph.Edge edge = (Graph.Edge)it.next();
            if (!selector.test(edge, true)) continue;
            path.push(edge);
            Object node = edge.getHead();
            if (terminator.test(node)) {
                return true;
            }
            if (!searched.contains(node) && (found = Graphs.findPathRecur(graph, node, selector, terminator, searched, path))) {
                return true;
            }
            path.pop();
        }
        return false;
    }

    public static final List edgePathToNodePath(List edgePath) {
        ArrayList<Object> path = new ArrayList<Object>();
        Graph.Edge lastEdge = null;
        Iterator edges = edgePath.iterator();
        while (edges.hasNext()) {
            Graph.Edge edge = (Graph.Edge)edges.next();
            if (lastEdge != null && !lastEdge.getHead().equals(edge.getTail())) {
                throw new IllegalArgumentException("non-contiguous path segment:\n" + lastEdge + "\n" + edge);
            }
            path.add(edge.getTail());
            lastEdge = edge;
        }
        if (lastEdge != null) {
            path.add(lastEdge.getHead());
        }
        return path;
    }

    private static String objToString(Object obj) {
        return obj == null ? "null" : obj.toString();
    }

    public static Graph nodesReachableFrom(Graph graph, Object start) {
        Assert.assertTrue(graph.hasNode(start));
        GraphSet result = new GraphSet();
        result.addNode(start);
        HashSet processedTails = new HashSet();
        Graphs.nodesReachableRecurse(graph, start, processedTails, result);
        return result;
    }

    private static void nodesReachableRecurse(Graph gg, Object currentNode, Set processedTails, Graph accumulator) {
        processedTails.add(currentNode);
        Iterator edges = gg.getOutgoingEdges(currentNode).iterator();
        while (edges.hasNext()) {
            Graph.Edge edge = (Graph.Edge)edges.next();
            if (processedTails.contains(edge.getHead())) continue;
            accumulator.addEdge(edge);
            Graphs.nodesReachableRecurse(gg, edge.getHead(), processedTails, accumulator);
        }
    }

    public static List getSinkNodes(Graph gg) {
        ArrayList result = new ArrayList();
        Iterator nodes = gg.getNodes().iterator();
        while (nodes.hasNext()) {
            Object node = nodes.next();
            if (gg.getOutgoingEdges(node).size() != 0) continue;
            result.add(node);
        }
        return result;
    }

    public static void printTree(Tree tree, GraphFormatter fmtr, PrintWriter writer) {
        Assert.assertNotNull(tree, "tree");
        Assert.assertNotNull(fmtr, "formatter");
        Assert.assertNotNull(writer, "writer");
        writer.println("digraph " + tree.getLabel() + " {");
        Graphs.printTreeRecurse(tree, fmtr, writer);
        writer.println("}");
    }

    private static void printTreeRecurse(Tree tree, GraphFormatter fmtr, PrintWriter writer) {
        String root = fmtr.nodeName(tree.getRoot());
        Iterator ii = tree.getSubtrees().iterator();
        while (ii.hasNext()) {
            Tree.EdgeTreePair pair = (Tree.EdgeTreePair)ii.next();
            String edge = fmtr.edge(pair.getEdge());
            String child = fmtr.nodeName(pair.getTree().getRoot());
            writer.print(INDENT + root + " -> " + child);
            if (edge != null) {
                writer.print("[label=\"" + edge + "\"]");
            }
            writer.println(";");
            Graphs.printTreeRecurse(pair.getTree(), fmtr, writer);
        }
    }

    public static void printGraph(Graph graph, GraphFormatter fmtr, PrintWriter writer) {
        Assert.assertNotNull(graph, "tree");
        Assert.assertNotNull(fmtr, "formatter");
        Assert.assertNotNull(writer, "writer");
        writer.println("digraph " + graph.getLabel() + " {");
        String graphAttrs = fmtr.graphAttributes(graph);
        if (graphAttrs != null) {
            writer.println(graphAttrs);
        }
        Iterator nodes = graph.getNodes().iterator();
        while (nodes.hasNext()) {
            Object node = nodes.next();
            int nodeCount = graph.outgoingEdgeCount(node) + graph.incomingEdgeCount(node);
            String nodeName = fmtr.nodeName(node);
            String nodeAttrs = fmtr.nodeAttributes(node);
            if (nodeCount == 0 || nodeAttrs != null) {
                writer.print(INDENT + nodeName);
                if (nodeAttrs == null) {
                    writer.println(";");
                } else {
                    writer.println(nodeAttrs + ";");
                }
            }
            if (graph.outgoingEdgeCount(node) == 0) continue;
            Iterator edges = graph.getOutgoingEdges(node).iterator();
            while (edges.hasNext()) {
                Graph.Edge edge = (Graph.Edge)edges.next();
                StringBuffer sb = new StringBuffer();
                sb.append(INDENT).append(fmtr.nodeName(edge.getTail()));
                sb.append(" -> ").append(fmtr.nodeName(edge.getHead()));
                if (edge.getLabel() != null) {
                    sb.append("[label=\"");
                    sb.append(fmtr.edge(edge.getLabel()));
                    sb.append("\"]");
                }
                sb.append(";");
                writer.println(sb.toString());
            }
        }
        writer.println("}");
    }

    public static final class EqualityTerminator
    implements NodeSelector {
        private Object m_node;

        public EqualityTerminator(Object node) {
            if (node == null) {
                throw new NullPointerException("node");
            }
            this.m_node = node;
        }

        public boolean test(Object node) {
            return this.m_node.equals(node);
        }
    }

    public static interface NodeSelector {
        public boolean test(Object var1);
    }

    public static interface EdgeSelector {
        public boolean test(Graph.Edge var1, boolean var2);
    }
}

