/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.util;

import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectObserver;
import com.arsdigita.domain.ObservableDomainObject;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataOperation;
import com.arsdigita.persistence.SessionManager;
import org.apache.log4j.Logger;

public abstract class HierarchyDenormalization {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/util/HierarchyDenormalization.java#13 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$util$HierarchyDenormalization == null ? (class$com$arsdigita$util$HierarchyDenormalization = HierarchyDenormalization.class$("com.arsdigita.util.HierarchyDenormalization")) : class$com$arsdigita$util$HierarchyDenormalization));
    static /* synthetic */ Class class$com$arsdigita$util$HierarchyDenormalization;

    public HierarchyDenormalization(String operationName, ObservableDomainObject object, String attributeName) {
        this(operationName, object, attributeName, "id");
    }

    public HierarchyDenormalization(String operationName, ObservableDomainObject object, String attributeName, String id) {
        object.addObserver(new Observer(operationName, attributeName, id));
    }

    public void beforeSave() {
    }

    public void afterSave() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Observer
    implements DomainObjectObserver {
        private final String m_attributeName;
        private final String m_id;
        private final String m_operationName;
        private boolean m_isModified = false;
        private String m_oldAttributeValue;
        private String m_newAttributeValue;

        Observer(String operationName, String attributeName, String id) {
            this.m_id = id;
            this.m_operationName = operationName;
            this.m_attributeName = attributeName;
        }

        public void set(DomainObject dobj, String name, Object old_value, Object new_value) {
            if (!name.equals(this.m_attributeName)) {
                return;
            }
            if (this.m_isModified) {
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Got another set on " + dobj + "." + name + " old " + old_value + " new " + new_value));
                }
                this.m_newAttributeValue = (String)new_value;
            } else {
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Got set on " + dobj + "." + name + " old " + old_value + " new " + new_value));
                }
                this.m_oldAttributeValue = (String)old_value;
                this.m_newAttributeValue = (String)new_value;
                this.m_isModified = true;
            }
        }

        public void add(DomainObject dobj, String name, DataObject dataObject) {
        }

        public void remove(DomainObject dobj, String name, DataObject dataObject) {
        }

        public void clear(DomainObject dobj, String name) {
        }

        public void beforeSave(DomainObject dobj) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("In before save for " + dobj));
            }
        }

        public void afterSave(DomainObject dobj) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("In after save for " + dobj));
            }
            if (!this.m_isModified) {
                return;
            }
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("After save: oid:" + dobj + " new value is:" + this.m_newAttributeValue + " old value is:" + this.m_oldAttributeValue));
            }
            if (this.m_oldAttributeValue == null && this.m_newAttributeValue == null || this.m_oldAttributeValue != null && this.m_oldAttributeValue.equals(this.m_newAttributeValue)) {
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)"Aborting because both null, or equal");
                }
                return;
            }
            if (this.m_oldAttributeValue == null) {
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)"Aborting because old is null");
                }
                this.m_isModified = false;
                return;
            }
            DataOperation operation = SessionManager.getSession().retrieveDataOperation(this.m_operationName);
            operation.setParameter("id", dobj.getOID().get(this.m_id));
            operation.setParameter("newPrefix", this.m_newAttributeValue);
            operation.setParameter("oldPrefixLength", new Integer(this.m_oldAttributeValue.length()));
            operation.setParameter("oldPrefix", this.m_oldAttributeValue);
            operation.execute();
            this.m_isModified = false;
        }

        public void beforeDelete(DomainObject dobj) {
        }

        public void afterDelete(DomainObject dobj) {
        }

        public boolean equals(Object other) {
            if (other instanceof Observer) {
                Observer o = (Observer)other;
                return this.m_operationName.equals(o.m_operationName) && this.m_id.equals(o.m_id) && this.m_attributeName.equals(o.m_attributeName);
            }
            return false;
        }

        public int hashCode() {
            return this.m_operationName.hashCode();
        }
    }
}

