/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.util;

import java.util.Arrays;
import java.util.HashMap;
import org.apache.log4j.Logger;

public final class Tracer {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/util/Tracer.java#4 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$util$Tracer == null ? (class$com$arsdigita$util$Tracer = Tracer.class$("com.arsdigita.util.Tracer")) : class$com$arsdigita$util$Tracer));
    private Logger m_log;
    private int m_level;
    private HashMap m_starts;
    static /* synthetic */ Class class$com$arsdigita$util$Tracer;

    public Tracer(Logger log) {
        this.m_log = log;
        this.m_level = 0;
        this.m_starts = new HashMap();
    }

    public Tracer(String category) {
        this(Logger.getLogger((String)category));
    }

    public Tracer(Class clacc) {
        this(clacc.getName() + ".trace");
    }

    public final boolean isEnabled() {
        return this.m_log.isDebugEnabled();
    }

    public final void enter(String method) {
        if (this.isEnabled()) {
            this.enter(method, new Object[0]);
        }
    }

    public final void enter(String method, Object arg1) {
        if (this.isEnabled()) {
            this.enter(method, new Object[]{arg1});
        }
    }

    public final void enter(String method, Object arg1, Object arg2) {
        if (this.isEnabled()) {
            this.enter(method, new Object[]{arg1, arg2});
        }
    }

    public final void enter(String method, Object arg1, Object arg2, Object arg3) {
        if (this.isEnabled()) {
            this.enter(method, new Object[]{arg1, arg2, arg3});
        }
    }

    public final void enter(String method, Object[] args) {
        if (this.isEnabled()) {
            ++this.m_level;
            StringBuffer buffer = this.buffer();
            buffer.append(method);
            this.m_starts.put(buffer.toString(), new Long(System.currentTimeMillis()));
            buffer.append(" ");
            buffer.append(Arrays.asList(args));
            this.m_log.debug((Object)buffer.toString());
        }
    }

    public final void exit(String method) {
        if (this.isEnabled()) {
            this.exit(method, null);
        }
    }

    public final void exit(String method, Object result) {
        if (this.isEnabled()) {
            StringBuffer buffer = this.buffer();
            buffer.append(method);
            long start = (Long)this.m_starts.get(buffer.toString());
            long end = System.currentTimeMillis();
            if (result != null) {
                buffer.append(" -> ");
                buffer.append(result);
            }
            buffer.append(" (");
            buffer.append(end - start);
            buffer.append(" millis)");
            this.m_log.debug((Object)buffer.toString());
            --this.m_level;
        }
    }

    private StringBuffer buffer() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.m_level; ++i) {
            buffer.append("  ");
        }
        return buffer;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

