/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.util.cmd;

import com.arsdigita.util.cmd.Switch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CommandLine {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/util/cmd/CommandLine.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private String m_name;
    private String m_usage;
    private Map m_switches = new HashMap();

    public CommandLine(String name, String usage) {
        this.m_name = name;
        this.m_usage = usage;
    }

    public void addSwitch(Switch s) {
        this.m_switches.put(s.getName(), s);
    }

    public Switch getSwitch(String name) {
        return (Switch)this.m_switches.get(name);
    }

    public String[] parse(Map result, String[] argv) {
        Iterator it = this.m_switches.values().iterator();
        while (it.hasNext()) {
            Switch s = (Switch)it.next();
            result.put(s.getName(), s.getDefault());
        }
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(Arrays.asList(argv));
        ArrayList<String> remaining = new ArrayList<String>();
        while (args.size() > 0) {
            String arg = (String)args.get(0);
            if (arg.startsWith("-")) {
                if (this.m_switches.containsKey(arg)) {
                    Switch s = (Switch)this.m_switches.get(arg);
                    result.put(s.getName(), s.parse(this, args));
                    continue;
                }
                throw new Error(this.usage());
            }
            args.remove(0);
            remaining.add(arg);
        }
        return remaining.toArray(new String[0]);
    }

    public String usage() {
        StringBuffer result = new StringBuffer();
        result.append("Usage: " + this.m_name);
        if (this.m_usage != null) {
            result.append(" " + this.m_usage);
        }
        Iterator it = this.m_switches.values().iterator();
        while (it.hasNext()) {
            Switch s = (Switch)it.next();
            result.append('\n');
            result.append(s.usage());
        }
        return result.toString();
    }

    public String usage(String name) {
        return this.getSwitch(name).usage();
    }
}

