/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.util.parameter;

import com.arsdigita.util.StringUtils;
import com.arsdigita.util.parameter.ErrorList;
import com.arsdigita.util.parameter.StringParameter;

public class StringArrayParameter
extends StringParameter {
    public StringArrayParameter(String name, int multiplicity, Object defaalt) {
        super(name, multiplicity, defaalt);
    }

    protected String marshal(Object value) {
        if (value == null) {
            return null;
        }
        return StringUtils.join((String[])value, ',');
    }

    protected Object unmarshal(String literal, ErrorList errors) {
        String[] literals = StringUtils.split(literal, ',');
        String[] strings = new String[literals.length];
        for (int i = 0; i < literals.length; ++i) {
            String elem = literals[i];
            strings[i] = (String)super.unmarshal(elem, errors);
            if (!errors.isEmpty()) break;
        }
        return strings;
    }

    protected void doValidate(Object value, ErrorList errors) {
        if (value != null) {
            String[] strings = (String[])value;
            for (int i = 0; i < strings.length; ++i) {
                super.doValidate(strings[i], errors);
                if (!errors.isEmpty()) break;
            }
        }
    }
}

