/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.util.servlet;

import com.arsdigita.util.Assert;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class HttpHost {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/util/servlet/HttpHost.java#4 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$util$servlet$HttpHost == null ? (class$com$arsdigita$util$servlet$HttpHost = HttpHost.class$("com.arsdigita.util.servlet.HttpHost")) : class$com$arsdigita$util$servlet$HttpHost));
    private final String m_name;
    private final int m_port;
    static /* synthetic */ Class class$com$arsdigita$util$servlet$HttpHost;
    static /* synthetic */ Class class$java$lang$String;

    public HttpHost(String name, int port) {
        if (Assert.isEnabled()) {
            Assert.exists(name, class$java$lang$String == null ? (class$java$lang$String = HttpHost.class$("java.lang.String")) : class$java$lang$String);
            Assert.truth(port > 0, "The port must be greater than 0; I got " + port);
        }
        this.m_name = name;
        this.m_port = port;
    }

    public HttpHost(HttpServletRequest sreq) {
        String header = sreq.getHeader("Host");
        if (header == null) {
            if (s_log.isInfoEnabled()) {
                s_log.info((Object)"No 'Host:' header present; falling back on values from servlet request");
            }
            this.m_name = sreq.getServerName();
            this.m_port = sreq.getServerPort();
        } else {
            int colon = header.indexOf(58);
            if (colon == -1) {
                this.m_name = header;
                String agent = sreq.getHeader("User-Agent");
                this.m_port = agent != null && agent.toLowerCase().indexOf("msie") >= 0 ? sreq.getServerPort() : 80;
            } else {
                this.m_name = header.substring(0, colon);
                this.m_port = Integer.parseInt(header.substring(colon + 1, header.length()));
            }
        }
    }

    public final String getName() {
        return this.m_name;
    }

    public final int getPort() {
        return this.m_port;
    }

    final void toString(StringBuffer buffer) {
        buffer.append(this.getName());
        int port = this.getPort();
        if (port != 80) {
            buffer.append(":");
            buffer.append(port);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(24);
        this.toString(buffer);
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

