/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.util.url;

import com.arsdigita.util.Assert;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.apache.log4j.Logger;

public class URLData {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$util$url$URLData == null ? (class$com$arsdigita$util$url$URLData = URLData.class$("com.arsdigita.util.url.URLData")) : class$com$arsdigita$util$url$URLData));
    private String m_url;
    private Map m_headers;
    private byte[] m_content;
    private Exception m_exception;
    private String m_data;
    static /* synthetic */ Class class$com$arsdigita$util$url$URLData;

    public URLData(String url) {
        this(url, null, null);
    }

    public URLData(String url, Map headers, byte[] content) {
        Assert.assertNotNull(url);
        this.m_url = null;
        this.setHeaders(headers);
        this.setContent(content);
    }

    public String getURL() {
        return this.m_url;
    }

    public Map getHeaders() {
        return this.m_headers;
    }

    public void setHeaders(Map headers) {
        this.m_headers = headers;
    }

    public byte[] getContent() {
        if (this.m_content == null) {
            this.m_content = new byte[0];
        }
        return this.m_content;
    }

    public void setContent(byte[] content) {
        this.m_content = content;
    }

    public String getContentAsString() {
        int offset;
        String contentType = this.getContentType();
        String encoding = "ISO-8859-1";
        if (contentType != null && (offset = contentType.indexOf("charset=")) != -1) {
            encoding = contentType.substring(offset + 8).trim();
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Received content type " + this.getContentType()));
        }
        try {
            return new String(this.getContent(), encoding);
        }
        catch (UnsupportedEncodingException e) {
            s_log.warn((Object)("Encoding " + encoding + " not supported."), (Throwable)e);
            return new String(this.getContent());
        }
    }

    public void setException(Exception e) {
        this.m_exception = e;
    }

    public Exception getException() {
        return this.m_exception;
    }

    public String getContentType() {
        if (this.getHeaders() != null) {
            return (String)this.getHeaders().get("content-type");
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

