/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.util.url;

import com.arsdigita.util.StringUtils;
import com.arsdigita.util.url.URLData;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class URLPool {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$util$url$URLPool == null ? (class$com$arsdigita$util$url$URLPool = URLPool.class$("com.arsdigita.util.url.URLPool")) : class$com$arsdigita$util$url$URLPool));
    private int m_currentThreadCount = 0;
    private int m_maxThreadCount;
    private long m_timeOut;
    static /* synthetic */ Class class$com$arsdigita$util$url$URLPool;

    public URLPool() {
        this(10, 4000L);
    }

    public URLPool(int poolsize) {
        this(poolsize, 4000L);
    }

    public URLPool(int threadCount, long timeout) {
        URLPool.assertThreadCount(threadCount);
        URLPool.assertTimeout(timeout);
        this.m_maxThreadCount = threadCount;
        this.m_timeOut = timeout;
    }

    private static void assertThreadCount(int threadCount) {
        if (threadCount <= 0) {
            throw new IllegalArgumentException("Thread Count must be greater than 0, not " + threadCount);
        }
    }

    private static void assertTimeout(long timeout) {
        if (timeout <= 0L) {
            throw new IllegalArgumentException("Timeout must be greater than 0, not " + timeout);
        }
    }

    public int getMaxThreadCount() {
        return this.m_maxThreadCount;
    }

    public void setMaxThreadCount(int maxThreadCount) {
        URLPool.assertThreadCount(maxThreadCount);
        this.m_maxThreadCount = maxThreadCount;
    }

    public long getTimeOut() {
        return this.m_timeOut;
    }

    public void setTimeOut(long timeOut) {
        URLPool.assertTimeout(timeOut);
        this.m_timeOut = timeOut;
    }

    public String fetchURL(String url) {
        URLData data = this.fetchURLData(url);
        if (data != null) {
            return data.getContentAsString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URLData fetchURLData(String url) {
        URL theURL = null;
        try {
            theURL = URLPool.makeURL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("URL " + url + " is invalid: " + e.getMessage());
        }
        while (this.m_currentThreadCount > this.m_maxThreadCount) {
            try {
                Thread.sleep(this.m_timeOut / 2L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        ++this.m_currentThreadCount;
        URLFetcher fetcher = new URLFetcher(theURL);
        s_log.debug((Object)("Starting fetch thread for " + url));
        try {
            fetcher.start();
            try {
                fetcher.join(this.m_timeOut);
                if (fetcher.isAlive()) {
                    s_log.debug((Object)("Thread still alive after " + this.m_timeOut + " milliseconds " + url));
                    fetcher.shutdown();
                    s_log.debug((Object)"Shutdown thread");
                }
            }
            catch (InterruptedException ex) {
                s_log.debug((Object)"URL Fetcher interrupted", (Throwable)ex);
            }
        }
        finally {
            s_log.debug((Object)"decrement");
            --this.m_currentThreadCount;
        }
        s_log.debug((Object)"Getting data");
        return fetcher.getData();
    }

    private static URL makeURL(String url) throws MalformedURLException {
        if (StringUtils.emptyString(url)) {
            throw new IllegalArgumentException("Cannot have an empty URL!");
        }
        if (url.indexOf("://") == -1) {
            url = "http://" + url;
        }
        URL theURL = new URL(url);
        return theURL;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class URLFetcher
    extends Thread {
        private URLData m_data;
        private URL m_url;
        private boolean m_running = true;

        public URLFetcher(URL url) {
            this.m_url = url;
            this.m_data = new URLData(url.toString());
        }

        public URLData getData() {
            return this.m_data;
        }

        public void shutdown() {
            this.m_running = false;
        }

        public synchronized void start() {
            super.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            if (!this.m_running) {
                return;
            }
            InputStream is = null;
            InputStreamReader isr = null;
            BufferedReader input = null;
            URLConnection con = this.m_url.openConnection();
            is = con.getInputStream();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] buffer = new byte[8];
            int length = -1;
            while ((length = is.read(buffer)) != -1) {
                os.write(buffer, 0, length);
            }
            this.m_data.setContent(os.toByteArray());
            int i = 1;
            String currentKey = con.getHeaderFieldKey(i);
            HashMap<String, String> headers = new HashMap<String, String>();
            this.m_data.setHeaders(headers);
            while (currentKey != null) {
                String currentValue = con.getHeaderField(i);
                headers.put(currentKey.toLowerCase(), currentValue);
                currentKey = con.getHeaderFieldKey(++i);
            }
            Object var13_13 = null;
            if (null == input) return;
            try {
                input.close();
                isr.close();
                is.close();
                return;
            }
            catch (IOException ioe) {
                s_log.error((Object)"Error closing connection", (Throwable)ioe);
            }
            return;
            {
                catch (IOException io) {
                    s_log.error((Object)("IO Error fetching URL: " + this.m_url), (Throwable)io);
                    this.m_data.setException(io);
                    Object var13_14 = null;
                    if (null == input) return;
                    try {
                        input.close();
                        isr.close();
                        is.close();
                        return;
                    }
                    catch (IOException ioe) {
                        s_log.error((Object)"Error closing connection", (Throwable)ioe);
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                if (null == input) throw throwable;
                try {
                    input.close();
                    isr.close();
                    is.close();
                    throw throwable;
                }
                catch (IOException ioe) {
                    s_log.error((Object)"Error closing connection", (Throwable)ioe);
                }
                throw throwable;
            }
        }
    }
}

