/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.versioning;

import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.util.AssertionError;
import com.arsdigita.versioning.Constants;
import com.arsdigita.versioning.ObjectTypeMetadata;

final class DiffState
implements Constants {
    private final VType m_vType;
    private CD m_cd = CD.UNKNOWN;
    private ACE m_actualCurrent = null;
    private ECE m_expectedCurrent = ECE.UNKNOWN;
    private EPE m_previousEPE;
    private EPE m_expectedPast = EPE.UNKNOWN;

    DiffState(ObjectType objType) {
        ObjectTypeMetadata otmd = ObjectTypeMetadata.getInstance();
        if (otmd.isFullyVersioned(objType)) {
            this.m_vType = VType.VERSIONED;
        } else if (otmd.isRecoverable(objType)) {
            this.m_vType = VType.RECOVERABLE;
        } else if (otmd.isUnreachable(objType)) {
            this.m_vType = VType.IGNORABLE;
        } else {
            throw new AssertionError("can't possibly get here: " + this);
        }
    }

    public boolean isVersioned() {
        return this.m_vType == VType.VERSIONED;
    }

    public boolean isRecoverable() {
        return this.m_vType == VType.RECOVERABLE;
    }

    public boolean isIgnorable() {
        return this.m_vType == VType.IGNORABLE;
    }

    public CD getCreateDeleteStatus() {
        return this.m_cd;
    }

    public void setCreateDeleteStatus(boolean consistent) {
        this.m_cd = consistent ? CD.CONSISTENT : CD.INCONSISTENT;
    }

    public ACE getActualCurrent() {
        return this.m_actualCurrent;
    }

    public void setActualCurrent(boolean exists) {
        this.m_actualCurrent = exists ? ACE.ON : ACE.OFF;
    }

    public ECE getExpectedCurrent() {
        return this.m_expectedCurrent;
    }

    public EPE getExpectedPast() {
        return this.m_expectedPast;
    }

    public void setExpectedPast(boolean existed) {
        EPE epe;
        if (this.m_previousEPE == null) {
            this.m_expectedCurrent = existed ? ECE.OFF : ECE.ON;
        }
        EPE ePE = epe = existed ? EPE.ON : EPE.OFF;
        if (epe == this.m_previousEPE) {
            this.m_cd = CD.INCONSISTENT;
        }
        this.m_previousEPE = this.m_expectedPast;
        this.m_expectedPast = epe;
    }

    public String toShortString() {
        String comma = ",";
        StringBuffer sb = new StringBuffer(64);
        sb.append("(");
        sb.append(this.m_vType.shortName()).append(",");
        sb.append(this.m_cd.shortName()).append(",");
        sb.append(this.m_actualCurrent == null ? "<null>" : this.m_actualCurrent.shortName());
        sb.append(",");
        sb.append(this.m_expectedCurrent.shortName()).append(",");
        sb.append(this.m_expectedPast.shortName());
        sb.append(")");
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        sb.append("short state: ").append(this.toShortString()).append(Constants.LINE_SEP);
        sb.append(this.m_vType).append(Constants.LINE_SEP);
        sb.append(this.m_cd).append(Constants.LINE_SEP);
        sb.append(this.m_actualCurrent).append(Constants.LINE_SEP);
        sb.append(this.m_expectedCurrent).append(Constants.LINE_SEP);
        sb.append(this.m_expectedPast).append(Constants.LINE_SEP);
        return sb.toString();
    }

    private static final class VType
    extends Enum {
        public static final VType VERSIONED = new VType("versioned");
        public static final VType RECOVERABLE = new VType("recoverable");
        public static final VType IGNORABLE = new VType("ignorable");

        private VType(String name) {
            super("V-Type", name);
        }
    }

    static final class EPE
    extends Enum {
        public static final EPE OFF = new EPE("off");
        public static final EPE ON = new EPE("on");
        public static final EPE UNKNOWN = new EPE("unknown");

        private EPE(String name) {
            super("Expected Past Existence", name);
        }
    }

    static final class ECE
    extends Enum {
        public static final ECE OFF = new ECE("off");
        public static final ECE ON = new ECE("on");
        public static final ECE UNKNOWN = new ECE("unknown");

        private ECE(String name) {
            super("Expected Current Existence", name);
        }
    }

    static final class ACE
    extends Enum {
        public static final ACE OFF = new ACE("off");
        public static final ACE ON = new ACE("on");

        private ACE(String name) {
            super("Actual Current Existence", name);
        }
    }

    static final class CD
    extends Enum {
        public static final CD CONSISTENT = new CD("consistent");
        public static final CD INCONSISTENT = new CD("inconsistent");
        public static final CD UNKNOWN = new CD("unknown");

        private CD(String name) {
            super("Create-Delete", name);
        }
    }

    static abstract class Enum {
        private final String m_name;
        private final String m_string;

        protected Enum(String type, String instance) {
            this.m_name = instance;
            StringBuffer sb = new StringBuffer(64);
            sb.append(type).append(": ").append(instance);
            this.m_string = sb.toString();
        }

        public String shortName() {
            return this.m_name;
        }

        public String toString() {
            return this.m_string;
        }
    }
}

