/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.versioning;

import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.util.Assert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Difference {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/versioning/Difference.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final String[] STATES = new String[]{"Created", "Modified", "Deleted"};
    private static final int CREATED = 0;
    private static final int MODIFIED = 1;
    private static final int DELETED = 2;
    private ArrayList m_changes = new ArrayList();
    static /* synthetic */ Class class$com$arsdigita$persistence$metadata$Property;

    private static final boolean compare(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            return o1 == o2;
        }
        return o1.equals(o2);
    }

    Change create(OID oid) {
        return new Change(oid, 0);
    }

    Change delete(OID oid) {
        return new Change(oid, 2);
    }

    Change modify(OID oid) {
        return new Change(oid, 1);
    }

    void addChange(Change change) {
        if (!change.isEmpty()) {
            this.m_changes.add(change);
        }
    }

    public Collection getChanges() {
        return this.m_changes;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class Change {
        private OID m_oid;
        private int m_state;
        private Map m_from = new HashMap();
        private Map m_to = new HashMap();
        private Map m_added = new HashMap();
        private Map m_removed = new HashMap();

        private Change(OID oid, int state) {
            this.m_oid = oid;
            this.m_state = state;
        }

        public OID getOID() {
            return this.m_oid;
        }

        public int getState() {
            return this.m_state;
        }

        boolean isEmpty() {
            Collection c;
            if (this.isCreated() || this.isDeleted()) {
                return false;
            }
            if (this.m_from.size() > 0) {
                return false;
            }
            Iterator it = this.m_added.values().iterator();
            while (it.hasNext()) {
                c = (Collection)it.next();
                if (c.size() <= 0) continue;
                return false;
            }
            it = this.m_removed.values().iterator();
            while (it.hasNext()) {
                c = (Collection)it.next();
                if (c.size() <= 0) continue;
                return false;
            }
            return true;
        }

        Property toProp(String propertyName) {
            Property prop = this.m_oid.getObjectType().getProperty(propertyName);
            Assert.exists(prop, class$com$arsdigita$persistence$metadata$Property == null ? (class$com$arsdigita$persistence$metadata$Property = Difference.class$("com.arsdigita.persistence.metadata.Property")) : class$com$arsdigita$persistence$metadata$Property);
            return prop;
        }

        void setFrom(String prop, Object value) {
            this.setFrom(this.toProp(prop), value);
        }

        void setTo(String prop, Object value) {
            this.setTo(this.toProp(prop), value);
        }

        void clearFrom(String prop) {
            this.clearFrom(this.toProp(prop));
        }

        void clearFrom(Property prop) {
            this.m_from.remove(prop);
        }

        void setFrom(Property prop, Object value) {
            this.m_from.put(prop, value);
        }

        void setTo(Property prop, Object value) {
            if (Difference.compare(this.getFrom(prop), value)) {
                this.clearFrom(prop);
            } else {
                this.m_to.put(prop, value);
            }
        }

        public boolean isCreated() {
            return this.m_state == 0;
        }

        public boolean isDeleted() {
            return this.m_state == 2;
        }

        public boolean isModified(Property prop) {
            if (prop.isCollection()) {
                return this.getAdded(prop).size() > 0 || this.getRemoved(prop).size() > 0;
            }
            return this.m_from.containsKey(prop);
        }

        private Object get(Map map, Property prop) {
            if (map.containsKey(prop)) {
                return map.get(prop);
            }
            if (this.isDeleted()) {
                return null;
            }
            DataObject dobj = SessionManager.getSession().retrieve(this.m_oid);
            if (dobj == null) {
                return null;
            }
            Object result = dobj.get(prop.getName());
            if (result instanceof DataObject) {
                result = ((DataObject)result).getOID();
            }
            return result;
        }

        public Object getFrom(Property prop) {
            return this.get(this.m_from, prop);
        }

        public Object getTo(Property prop) {
            return this.get(this.m_to, prop);
        }

        private Collection getCollection(Map map, Property prop) {
            ArrayList result = (ArrayList)map.get(prop);
            if (result == null) {
                result = new ArrayList();
                map.put(prop, result);
            }
            return result;
        }

        Collection getAdded(String prop) {
            return this.getAdded(this.toProp(prop));
        }

        Collection getRemoved(String prop) {
            return this.getRemoved(this.toProp(prop));
        }

        public Collection getAdded(Property prop) {
            return this.getCollection(this.m_added, prop);
        }

        public Collection getRemoved(Property prop) {
            return this.getCollection(this.m_removed, prop);
        }

        public String toString() {
            return "<change state=" + STATES[this.m_state] + " oid=" + this.m_oid + "from=" + this.m_from + " to=" + this.m_to + " added=" + this.m_added + " removed=" + this.m_removed + ">";
        }
    }
}

