/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.versioning;

import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.DataQueryDataCollectionAdapter;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.versioning.Transaction;
import com.arsdigita.versioning.TransactionCollection;
import com.arsdigita.versioning.VersionedACSObject;
import java.math.BigDecimal;
import java.util.Date;

public class HistoryCollection
extends TransactionCollection {
    private static final String HISTORY_QUERY = "com.arsdigita.versioning.objectHistoryQuery";
    public static final String TRANS_ID = "transID";
    public static final String TRANS = "change";
    public static final String TIMESTAMP = "timestamp";
    public static final String EMAIL = "userEmail";
    public static final String COMMENT = "comment";
    public static final String SHOW_CURRENT = "showCurrent";
    public static final String DUMMY_ID = "dummyID";
    public static final BigDecimal DUMMY_ID_VALUE = new BigDecimal(-42.0);
    private DataQuery m_query;
    private int m_version;

    public static HistoryCollection getHistory(VersionedACSObject obj, boolean showCurrent) {
        DataQuery q = SessionManager.getSession().retrieveQuery(HISTORY_QUERY);
        q.setParameter(DUMMY_ID, DUMMY_ID_VALUE);
        q.setParameter(SHOW_CURRENT, new Boolean(showCurrent));
        return new HistoryCollection(q);
    }

    protected HistoryCollection(DataQuery q) {
        super(new DataQueryDataCollectionAdapter(q, TRANS));
        this.m_query = q;
        this.m_version = 0;
    }

    public boolean next() {
        boolean next = super.next();
        if (next) {
            ++this.m_version;
        }
        return next;
    }

    public Transaction getTransaction() {
        DataObject trans = (DataObject)this.m_query.get(TRANS);
        return new Transaction(trans);
    }

    public BigDecimal getTransactionID() {
        return (BigDecimal)this.m_query.get(TRANS_ID);
    }

    public String getUserEmail() {
        return (String)this.m_query.get(EMAIL);
    }

    public BigDecimal getVersion() {
        return new BigDecimal((double)this.m_version);
    }

    public Date getTimestamp() {
        return (Date)this.m_query.get(TIMESTAMP);
    }

    public String getComment() {
        return (String)this.m_query.get(COMMENT);
    }

    public DataQuery getQuery() {
        return this.m_query;
    }

    public static boolean isDummyID(BigDecimal id) {
        return DUMMY_ID_VALUE.equals(id);
    }
}

