/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.web;

import com.arsdigita.developersupport.DeveloperSupport;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.util.Assert;
import com.arsdigita.util.StringUtils;
import com.arsdigita.web.Application;
import com.arsdigita.web.BaseApplicationServlet;
import com.arsdigita.web.BaseServlet;
import com.arsdigita.web.PathMapCache;
import com.arsdigita.web.URL;
import com.arsdigita.web.Web;
import java.io.IOException;
import java.math.BigDecimal;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

class BaseDispatcher {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/web/BaseDispatcher.java#39 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$web$BaseDispatcher == null ? (class$com$arsdigita$web$BaseDispatcher = BaseDispatcher.class$("com.arsdigita.web.BaseDispatcher")) : class$com$arsdigita$web$BaseDispatcher));
    static final String DISPATCHED_ATTRIBUTE = (class$com$arsdigita$web$BaseDispatcher == null ? (class$com$arsdigita$web$BaseDispatcher = BaseDispatcher.class$("com.arsdigita.web.BaseDispatcher")) : class$com$arsdigita$web$BaseDispatcher).getName() + ".dispatched";
    private static final Cache s_cache = new Cache();
    static /* synthetic */ Class class$com$arsdigita$web$BaseDispatcher;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$servlet$RequestDispatcher;
    static /* synthetic */ Class class$java$math$BigDecimal;

    BaseDispatcher() {
    }

    public final boolean isApplicationInCache(String path) {
        return s_cache.isCached(path);
    }

    final boolean dispatch(HttpServletRequest sreq, HttpServletResponse sresp) throws ServletException, IOException {
        String path;
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Dispatching request " + sreq.getRequestURI() + " [" + sreq.getContextPath() + "," + sreq.getServletPath() + "," + sreq.getPathInfo() + "," + sreq.getQueryString() + "]"));
        }
        if (this.requiresTrailingSlash(path = sreq.getPathInfo())) {
            s_log.debug((Object)"The request URI needs a trailing slash; redirecting");
            String prefix = DispatcherHelper.getDispatcherPrefix(sreq);
            String uri = sreq.getRequestURI();
            if (prefix != null && prefix.trim().length() > 0) {
                uri = prefix + uri;
            }
            String query = sreq.getQueryString();
            Object url = null;
            if (query == null) {
                sresp.sendRedirect(sresp.encodeRedirectURL(uri + "/"));
            } else {
                sresp.sendRedirect(sresp.encodeRedirectURL(uri + "/?" + query));
            }
            return true;
        }
        Assert.exists(path, class$java$lang$String == null ? (class$java$lang$String = BaseDispatcher.class$("java.lang.String")) : class$java$lang$String);
        s_log.debug((Object)"Storing the path elements of the current request as the original path elements");
        sreq.setAttribute(BaseServlet.REQUEST_URL_ATTRIBUTE, (Object)new URL(sreq));
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Using path '" + path + "' to lookup application"));
        }
        DeveloperSupport.startStage("BaseDispatcher.lookupApplicationSpec");
        ApplicationSpec spec = this.lookupApplicationSpec(path);
        DeveloperSupport.endStage("BaseDispatcher.lookupApplicationSpec");
        if (spec == null) {
            s_log.debug((Object)"No application was found; doing nothing");
            return false;
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Found application " + spec.getAppID() + "; " + "dispatching to its servlet"));
        }
        sreq.setAttribute(BaseApplicationServlet.APPLICATION_ID_ATTRIBUTE, (Object)spec.getAppID());
        sreq.setAttribute(DISPATCHED_ATTRIBUTE, (Object)Boolean.TRUE);
        this.forward(spec.getTypeContextPath(), spec.target(path), sreq, sresp);
        return true;
    }

    private boolean requiresTrailingSlash(String path) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)"Checking if this request needs a trailing slash");
        }
        if (path == null) {
            s_log.debug((Object)"The path is null; the request needs a trailing slash");
            return true;
        }
        if (path.endsWith("/")) {
            s_log.debug((Object)"The path already ends in '/'");
            return false;
        }
        if (path.lastIndexOf(".") < path.lastIndexOf("/")) {
            s_log.debug((Object)"The last fragment of the path has no '.', so we assume a directory was requested; a trailing slash is required");
            return true;
        }
        s_log.debug((Object)"The last fragment of the path appears to be a file name; no trailing slash is needed");
        return false;
    }

    private final void forward(String contextPath, String target, HttpServletRequest sreq, HttpServletResponse sresp) throws ServletException, IOException {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Forwarding by path to target '" + target + "'"));
        }
        s_log.debug((Object)("The context path is: " + contextPath));
        if (StringUtils.emptyString(contextPath)) {
            contextPath = "/";
        }
        if (!contextPath.endsWith("/")) {
            contextPath = contextPath + "/";
        }
        ServletContext context = Web.getServletContext(contextPath);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("From context " + Web.getServletContext() + " to context " + context));
        }
        RequestDispatcher rd = context.getRequestDispatcher(target);
        Assert.exists(rd, class$javax$servlet$RequestDispatcher == null ? (class$javax$servlet$RequestDispatcher = BaseDispatcher.class$("javax.servlet.RequestDispatcher")) : class$javax$servlet$RequestDispatcher);
        this.forward(rd, sreq, sresp);
    }

    final void forward(RequestDispatcher rd, HttpServletRequest sreq, HttpServletResponse sresp) throws ServletException, IOException {
        s_log.debug((Object)("Checking if this request needs to be forwarded or included " + sreq));
        sreq = DispatcherHelper.restoreOriginalRequest(sreq);
        if (sreq.getAttribute("javax.servlet.include.request_uri") == null) {
            s_log.debug((Object)("The attribute javax.servlet.include.request_uri is not set; forwarding " + sreq));
            rd.forward((ServletRequest)sreq, (ServletResponse)sresp);
        } else {
            s_log.debug((Object)("The attribute javax.servlet.include.request_uri is set; including " + sreq));
            rd.include((ServletRequest)sreq, (ServletResponse)sresp);
        }
    }

    private ApplicationSpec lookupApplicationSpec(String path) {
        ApplicationSpec spec;
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("*** Starting application lookup for path '" + path + "' ***"));
        }
        if ((spec = s_cache.getAppSpec(path)) == null) {
            s_log.debug((Object)"There's no application to be found");
        }
        return spec;
    }

    static void scheduleRefresh() {
        s_cache.scheduleRefresh();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Cache
    extends PathMapCache {
        private static ThreadLocal s_handleHere = new ThreadLocal(){

            protected Object initialValue() {
                return Boolean.FALSE;
            }
        };

        public Cache() {
            super("BaseDispatcherCache");
        }

        public String normalize(String path) {
            if (path == null) {
                throw new NullPointerException("path");
            }
            if (!path.startsWith("/")) {
                throw new DataObjectNotFoundException("The URL path specified must begin with a '/'.");
            }
            return path.endsWith("/") ? path : path.substring(0, path.lastIndexOf(47) + 1);
        }

        public Object retrieve(String path) {
            Application app;
            if ("/".equals(path)) {
                return null;
            }
            TransactionContext context = SessionManager.getSession().getTransactionContext();
            if (!context.inTxn()) {
                s_log.debug((Object)"Beginning transaction");
                context.beginTxn();
                s_handleHere.set(Boolean.TRUE);
            }
            return (app = Application.retrieveApplicationForPath(path)) == null ? null : new ApplicationSpec(app);
        }

        public void refresh() {
            s_cache.clearAll();
        }

        void scheduleRefresh() {
            this.refreshAfterCommit();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized ApplicationSpec getAppSpec(String path) {
            try {
                ApplicationSpec applicationSpec = (ApplicationSpec)super.get(path);
                Object var4_3 = null;
                if (s_handleHere.get() == Boolean.TRUE) {
                    s_handleHere.set(Boolean.FALSE);
                    SessionManager.getSession().getTransactionContext().commitTxn();
                }
                return applicationSpec;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var4_4 = null;
                    if (s_handleHere.get() != Boolean.TRUE) break block3;
                    s_handleHere.set(Boolean.FALSE);
                    SessionManager.getSession().getTransactionContext().commitTxn();
                }
                throw throwable;
            }
        }
    }

    private static class ApplicationSpec {
        private final BigDecimal m_id;
        private final String m_instanceURI;
        private final String m_typeURI;
        private final String m_typeContextPath;

        ApplicationSpec(Application app) {
            if (app == null) {
                throw new NullPointerException("app");
            }
            this.m_id = app.getID();
            this.m_instanceURI = app.getPath();
            this.m_typeURI = app.getServletPath();
            this.m_typeContextPath = app.getContextPath();
            if (Assert.isEnabled()) {
                Assert.exists(this.m_id, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = BaseDispatcher.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
                Assert.exists(this.m_instanceURI, class$java$lang$String == null ? (class$java$lang$String = BaseDispatcher.class$("java.lang.String")) : class$java$lang$String);
                Assert.exists(this.m_typeURI, class$java$lang$String == null ? (class$java$lang$String = BaseDispatcher.class$("java.lang.String")) : class$java$lang$String);
                Assert.exists(this.m_typeContextPath, class$java$lang$String == null ? (class$java$lang$String = BaseDispatcher.class$("java.lang.String")) : class$java$lang$String);
            }
        }

        BigDecimal getAppID() {
            return this.m_id;
        }

        String getTypeContextPath() {
            return this.m_typeContextPath;
        }

        String target(String path) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Building the target path from the request path '" + path + "' and the spec " + this));
            }
            StringBuffer target = new StringBuffer(128);
            target.append(this.m_typeURI);
            target.append(path.substring(this.m_instanceURI.length()));
            target.append("?");
            target.append("app-id");
            target.append("=");
            target.append(this.m_id);
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Returning target value '" + target + "'"));
            }
            return target.toString();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            ApplicationSpec other = (ApplicationSpec)obj;
            return this.m_id.equals(other.m_id) && this.equal(this.m_instanceURI, other.m_instanceURI) && this.equal(this.m_typeURI, other.m_typeURI) && this.equal(this.m_typeContextPath, other.m_typeContextPath);
        }

        private boolean equal(String s1, String s2) {
            if (s1 == s2) {
                return true;
            }
            if (s1 == null) {
                return this.equal(s2, s1);
            }
            return s1.equals(s2);
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            String sep = ", ";
            StringBuffer sb = new StringBuffer();
            sb.append("[");
            sb.append("appID=").append(this.m_id).append(", ");
            sb.append("instanceURI=").append(this.m_instanceURI).append(", ");
            sb.append("typeURI=").append(this.m_typeURI).append(", ");
            sb.append("typeContextPath=").append(this.m_typeContextPath);
            return sb.append("]").toString();
        }
    }
}

