/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.web;

import com.arsdigita.db.Sequences;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainCollection;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.util.servlet.HttpHost;
import com.arsdigita.web.ParameterMap;
import com.arsdigita.web.URL;
import com.arsdigita.web.Web;
import com.arsdigita.web.WebConfig;
import java.math.BigDecimal;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class Host
extends DomainObject {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$web$Host == null ? (class$com$arsdigita$web$Host = Host.class$("com.arsdigita.web.Host")) : class$com$arsdigita$web$Host));
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.web.Host";
    public static final String ID = "id";
    public static final String SERVER_NAME = "serverName";
    public static final String SERVER_PORT = "serverPort";
    static /* synthetic */ Class class$com$arsdigita$web$Host;

    protected Host() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    protected Host(String type) {
        super(type);
    }

    public Host(DataObject dobj) {
        super(dobj);
    }

    public void initialize() {
        super.initialize();
        if (this.isNew()) {
            try {
                this.set(ID, Sequences.getNextValue());
            }
            catch (SQLException ex) {
                throw new UncheckedWrapperException("cannot allocate id", ex);
            }
        }
    }

    public static Host create(String serverName, int serverPort) {
        Host host = new Host();
        host.setServerName(serverName);
        host.setServerPort(serverPort);
        return host;
    }

    public static Host retrieve(BigDecimal id) {
        Session session = SessionManager.getSession();
        DataCollection hosts = session.retrieve(BASE_DATA_OBJECT_TYPE);
        hosts.addEqualsFilter(ID, id);
        if (hosts.next()) {
            Host host = new Host(hosts.getDataObject());
            hosts.close();
            return host;
        }
        throw new DataObjectNotFoundException("cannot find host with id " + id);
    }

    public static final DomainCollection retrieveAll() {
        Session session = SessionManager.getSession();
        DataCollection hosts = session.retrieve(BASE_DATA_OBJECT_TYPE);
        return new DomainCollection(hosts);
    }

    public static Host retrieve(HttpHost hhost) {
        String name = hhost.getName();
        Integer port = new Integer(hhost.getPort());
        Session session = SessionManager.getSession();
        DataCollection hosts = session.retrieve(BASE_DATA_OBJECT_TYPE);
        hosts.addEqualsFilter(SERVER_NAME, name);
        hosts.addEqualsFilter(SERVER_PORT, port);
        if (hosts.next()) {
            Host host = new Host(hosts.getDataObject());
            hosts.close();
            return host;
        }
        return null;
    }

    public static Host findByServerName(String serverName) {
        Session session = SessionManager.getSession();
        DataCollection hosts = session.retrieve(BASE_DATA_OBJECT_TYPE);
        hosts.addEqualsFilter(SERVER_NAME, serverName);
        if (hosts.next()) {
            Host host = new Host(hosts.getDataObject());
            hosts.close();
            return host;
        }
        throw new DataObjectNotFoundException("cannot find host with name " + serverName);
    }

    public BigDecimal getID() {
        return (BigDecimal)this.get(ID);
    }

    public String getServerName() {
        return (String)this.get(SERVER_NAME);
    }

    public void setServerName(String name) {
        this.set(SERVER_NAME, name);
    }

    public int getServerPort() {
        return (Integer)this.get(SERVER_PORT);
    }

    public void setServerPort(int port) {
        this.set(SERVER_PORT, new Integer(port));
    }

    public String toString() {
        if (this.getServerPort() == 80) {
            return this.getServerName();
        }
        return this.getServerName() + ":" + this.getServerPort();
    }

    public URL getURL() {
        return this.getURL(null, null);
    }

    public URL getURL(String path, ParameterMap params) {
        return this.getURL(Web.getConfig().getDefaultScheme(), path, params);
    }

    public URL getURL(String scheme, String path, ParameterMap params) {
        WebConfig config = Web.getConfig();
        return new URL(scheme, this.getServerName(), this.getServerPort(), config.getDispatcherContextPath(), config.getDispatcherServletPath(), path, params);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

