/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.web;

import com.arsdigita.caching.CacheTable;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.persistence.TransactionListenerImpl;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public abstract class PathMapCache {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$web$PathMapCache == null ? (class$com$arsdigita$web$PathMapCache = PathMapCache.class$("com.arsdigita.web.PathMapCache")) : class$com$arsdigita$web$PathMapCache));
    private final CacheTable m_table;
    private static ThreadLocal s_refreshing = new ThreadLocal(){

        protected Object initialValue() {
            return Boolean.FALSE;
        }
    };
    static /* synthetic */ Class class$com$arsdigita$web$PathMapCache;

    protected PathMapCache(String cacheID) {
        this.m_table = new CacheTable(cacheID);
    }

    protected final Object get(String path) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("path: " + path));
        }
        String normalizedPath = this.normalize(path);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("normalizedPath=" + normalizedPath));
        }
        LongestMatch fragments = new LongestMatch(normalizedPath);
        boolean found = false;
        boolean foundOnFirstTry = true;
        Object result = null;
        while (!found && fragments.hasNext()) {
            String fragment = (String)fragments.next();
            result = this.m_table.get(fragment);
            if (result == null) {
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("cache miss for " + fragment));
                }
                if ((result = this.retrieve(fragment)) != null) {
                    this.m_table.put(fragment, result);
                }
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("db " + (result == null ? "miss" : "hit") + " for " + fragment));
                }
            } else if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("cache hit for " + fragment));
            }
            boolean bl = found = result != null;
            if (found && !foundOnFirstTry) {
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("caching normalized path: " + normalizedPath));
                }
                this.m_table.put(normalizedPath, result);
            }
            foundOnFirstTry = false;
        }
        return result;
    }

    protected boolean isCached(String path) {
        return this.m_table.get(this.normalize(path)) != null;
    }

    protected void put(String path, Object value) {
        this.m_table.put(path, value);
    }

    protected void clearAll() {
        this.m_table.removeAll();
    }

    protected void refreshAfterCommit() {
        s_log.debug((Object)"entering refreshAfterCommit");
        if (s_refreshing.get().equals(Boolean.TRUE)) {
            return;
        }
        s_log.debug((Object)"scheduling site node cache refresh after commit");
        s_refreshing.set(Boolean.TRUE);
        Session session = SessionManager.getSession();
        TransactionContext txn = session.getTransactionContext();
        txn.addTransactionListener(new TransactionListenerImpl(){

            public void afterCommit(TransactionContext txn) {
                s_refreshing.set(Boolean.FALSE);
                txn.beginTxn();
                try {
                    PathMapCache.this.refresh();
                }
                catch (RuntimeException t) {
                    txn.abortTxn();
                    throw t;
                }
                txn.commitTxn();
            }

            public void beforeAbort(TransactionContext txn) {
            }

            public void afterAbort(TransactionContext txn) {
                s_refreshing.set(Boolean.FALSE);
            }
        });
        s_log.debug((Object)"exiting refreshAfterCommit");
    }

    protected abstract String normalize(String var1);

    protected abstract Object retrieve(String var1);

    protected abstract void refresh();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class LongestMatchException
    extends IllegalArgumentException {
        LongestMatchException(String msg) {
            super(msg);
        }
    }

    static class LongestMatch
    implements Iterator {
        private static final String SL = "/";
        private final String m_path;
        private int m_last;

        public LongestMatch(String path) {
            if (path == null) {
                throw new NullPointerException("path");
            }
            if (!path.startsWith(SL)) {
                throw new LongestMatchException("path should start with /: " + path);
            }
            if (!path.endsWith(SL)) {
                throw new LongestMatchException("path should end with /: " + path);
            }
            this.m_path = path;
            this.m_last = this.m_path.length() - 1;
        }

        public boolean hasNext() {
            return this.m_last > -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("initial path=" + this.m_path + "; current idx=" + this.m_last);
            }
            try {
                String string = this.m_path.substring(0, this.m_last + 1);
                Object var3_2 = null;
                this.m_last = this.m_path.lastIndexOf(47, this.m_last - 1);
                return string;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.m_last = this.m_path.lastIndexOf(47, this.m_last - 1);
                throw throwable;
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

