/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.webdevsupport;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.BebopMapDispatcher;
import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.ListPanel;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageFactory;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.TableActionAdapter;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.parameters.IntegerParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.table.AbstractTableModelBuilder;
import com.arsdigita.bebop.table.DefaultTableCellRenderer;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.developersupport.DeveloperSupport;
import com.arsdigita.dispatcher.AccessDeniedException;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.dispatcher.RequestContext;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.SiteNode;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.sitenode.SiteNodeRequestContext;
import com.arsdigita.util.StringUtils;
import com.arsdigita.web.LoginSignal;
import com.arsdigita.web.ParameterMap;
import com.arsdigita.web.RedirectSignal;
import com.arsdigita.web.URL;
import com.arsdigita.webdevsupport.CacheTableBrowser;
import com.arsdigita.webdevsupport.NonEscapedTableCellRenderer;
import com.arsdigita.webdevsupport.QueryInfo;
import com.arsdigita.webdevsupport.QueryLog;
import com.arsdigita.webdevsupport.QueryPlanComponent;
import com.arsdigita.webdevsupport.RequestInfo;
import com.arsdigita.webdevsupport.StageInfo;
import com.arsdigita.webdevsupport.WebDevSupport;
import com.arsdigita.webdevsupport.config.ConfigList;
import com.arsdigita.webdevsupport.log4j.CategoryPanel;
import com.arsdigita.xml.Element;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class Dispatcher
extends BebopMapDispatcher {
    private static final Logger s_log = Logger.getLogger((String)(class$com$arsdigita$webdevsupport$Dispatcher == null ? (class$com$arsdigita$webdevsupport$Dispatcher = Dispatcher.class$("com.arsdigita.webdevsupport.Dispatcher")) : class$com$arsdigita$webdevsupport$Dispatcher).getName());
    public static final String APP_NAME = "ds";
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/webdevsupport/Dispatcher.java#29 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static boolean s_showDSPages = false;
    private static final String CACHE_TABLE_URL = "cache-table";
    private ParameterModel m_request_id = new IntegerParameter("request_id");
    private ParameterModel m_query_id = new IntegerParameter("query_id");
    private ParameterModel m_query_request_id = new IntegerParameter("request_id");
    private RequestLocal m_scoreboard = new RequestLocal(){

        protected Object initialValue(PageState state) {
            return new HashMap();
        }
    };
    private ParameterModel m_query_p_id = new IntegerParameter("query_id");
    private ParameterModel m_query_p_request_id = new IntegerParameter("request_id");
    static /* synthetic */ Class class$com$arsdigita$webdevsupport$Dispatcher;

    public Dispatcher() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("", this.buildIndexPage());
        m.put("index", this.buildIndexPage());
        m.put("request-info", this.buildInfoPage());
        m.put("query-log", new QueryLog());
        m.put("query-info", this.buildQueryInfoPage());
        m.put("query-plan", this.buildQueryPlanPage());
        m.put("log4j", this.buildLog4jPage());
        m.put("config", this.buildConfigPage());
        m.put(CACHE_TABLE_URL, this.buildCacheTablePage());
        this.setMap(m);
    }

    public void dispatch(HttpServletRequest req, HttpServletResponse resp, RequestContext ctx) throws IOException, ServletException {
        Party party = Kernel.getContext().getParty();
        if (party == null) {
            throw new LoginSignal(req);
        }
        SiteNode node = ((SiteNodeRequestContext)ctx).getSiteNode();
        PermissionDescriptor admin = new PermissionDescriptor(PrivilegeDescriptor.ADMIN, node, party);
        if (!PermissionService.checkPermission(admin)) {
            throw new AccessDeniedException("user not an administrator");
        }
        DispatcherHelper.cacheDisable(resp);
        DeveloperSupport.requestAddProperty(null, "IS_DS", new Boolean(true));
        super.dispatch(req, resp, ctx);
    }

    private Page buildIndexPage() {
        Page p = PageFactory.buildPage(APP_NAME, "Web Developer Support");
        BoxPanel links = new BoxPanel(2);
        links.add(new Link("Log4j Logger Adjuster", "log4j"));
        links.add(new Link("Config Browser", "config"));
        links.add(new Link("Cache Table Browser", CACHE_TABLE_URL));
        ActionLink enable = new ActionLink("Enable request logging"){

            public boolean isVisible(PageState state) {
                return !DeveloperSupport.containsListener(WebDevSupport.getInstance()) && super.isVisible(state);
            }
        };
        enable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DeveloperSupport.addListener(WebDevSupport.getInstance());
                throw new RedirectSignal(URL.request(e.getPageState().getRequest(), null), true);
            }
        });
        links.add(enable);
        ActionLink disable = new ActionLink("Disable request logging"){

            public boolean isVisible(PageState state) {
                return DeveloperSupport.containsListener(WebDevSupport.getInstance()) && super.isVisible(state);
            }
        };
        disable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DeveloperSupport.removeListener(WebDevSupport.getInstance());
                WebDevSupport.getInstance().clearRequestHistory();
                throw new RedirectSignal(URL.request(e.getPageState().getRequest(), null), true);
            }
        });
        links.add(disable);
        BoxPanel logs = new BoxPanel(2){

            public boolean isVisible(PageState state) {
                return DeveloperSupport.containsListener(WebDevSupport.getInstance()) && super.isVisible(state);
            }
        };
        logs.add(new Label(""){

            public String getLabel(PageState ps) {
                return "Currently storing the last " + WebDevSupport.getInstance().getMaxRequests() + " requests";
            }
        });
        Label toggle = new Label(""){

            public String getLabel(PageState ps) {
                return s_showDSPages ? "Hide hits to developer support" : "Show hits to developer support";
            }
        };
        ControlLink cl = new ControlLink(toggle){

            public void respond(PageState s) {
                s_showDSPages = !s_showDSPages;
            }

            public void setControlEvent(PageState s) {
                s.setControlEvent(this);
            }
        };
        logs.add(cl);
        logs.add(new Label("<h3>Available Request Information</h3>", false));
        logs.add(this.makeRequestTable());
        p.add(links);
        p.add(logs);
        p.lock();
        return p;
    }

    private Page buildLog4jPage() {
        Page p = PageFactory.buildPage(APP_NAME, "Log4j Logger Adjuster");
        p.add(new CategoryPanel());
        p.lock();
        return p;
    }

    private Page buildConfigPage() {
        Page p = PageFactory.buildPage(APP_NAME, "Registry Config");
        p.add(new ConfigList());
        p.lock();
        return p;
    }

    private Page buildCacheTablePage() {
        Page p = PageFactory.buildPage(APP_NAME, "Cache Table Browser");
        p.add(new CacheTableBrowser());
        p.lock();
        return p;
    }

    private Page buildInfoPage() {
        Page p = PageFactory.buildPage(APP_NAME, "Request Information");
        p.addGlobalStateParam(this.m_request_id);
        p.add(new RequestInfoComponent());
        p.add(this.makeDatabaseRequestComponent());
        p.lock();
        return p;
    }

    private Page buildQueryInfoPage() {
        Page p = PageFactory.buildPage(APP_NAME, "Query Information");
        p.addGlobalStateParam(this.m_query_request_id);
        p.addGlobalStateParam(this.m_query_id);
        p.add(new QueryInfoComponent());
        p.lock();
        return p;
    }

    private void incrementScore(PageState state, QueryInfo key, int index) {
        Map map = (Map)this.m_scoreboard.get(state);
        Integer[] row = (Integer[])map.get(new Integer(key.getID()));
        if (row == null) {
            row = new Integer[]{new Integer(0), new Integer(0)};
            map.put(new Integer(key.getID()), row);
        }
        row[index] = new Integer(row[index] + 1);
    }

    private Component makeDatabaseRequestComponent() {
        Object[] headers = new String[]{"ID", "Duration", "Conn", "Command", "Exception"};
        AbstractTableModelBuilder b = new AbstractTableModelBuilder(){

            public TableModel makeModel(Table t, PageState s) {
                Integer request_id = (Integer)s.getValue(Dispatcher.this.m_request_id);
                RequestInfo ri = WebDevSupport.getInstance().getRequest(request_id);
                ListIterator iter = ri == null ? new ArrayList().iterator() : ri.getQueries();
                return new TableModel(this, iter, s){
                    private HashMap seenQueryAndValues;
                    private HashMap seenQuery;
                    private boolean duplicateQueryAndValues;
                    private boolean duplicateQuery;
                    private QueryInfo current;
                    private final /* synthetic */ Iterator val$iter;
                    private final /* synthetic */ PageState val$s;
                    private final /* synthetic */ 10 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$iter = val$iter;
                        this.val$s = val$s;
                        this.seenQueryAndValues = new HashMap<K, V>();
                        this.seenQuery = new HashMap<K, V>();
                        this.duplicateQueryAndValues = false;
                        this.duplicateQuery = false;
                        this.current = null;
                    }

                    public int getColumnCount() {
                        return 5;
                    }

                    public boolean nextRow() {
                        if (this.val$iter.hasNext()) {
                            this.current = (QueryInfo)this.val$iter.next();
                            this.duplicateQueryAndValues = this.seenQueryAndValues.containsKey(this.current);
                            this.duplicateQuery = this.seenQuery.containsKey(this.current.getQuery());
                            if (!this.duplicateQueryAndValues) {
                                this.seenQueryAndValues.put(this.current, this.current);
                            }
                            if (!this.duplicateQuery) {
                                this.seenQuery.put(this.current.getQuery(), this.current);
                            }
                            Dispatcher.access$300(10.access$200(this.this$1), this.val$s, (QueryInfo)this.seenQueryAndValues.get(this.current), 0);
                            Dispatcher.access$300(10.access$200(this.this$1), this.val$s, (QueryInfo)this.seenQuery.get(this.current.getQuery()), 1);
                            return true;
                        }
                        return false;
                    }

                    public Object getElementAt(int columnIndex) {
                        switch (columnIndex) {
                            case 0: {
                                StringBuffer result = new StringBuffer();
                                result.append(this.current.getID());
                                if (this.duplicateQueryAndValues) {
                                    result.append(" duplicates #" + ((QueryInfo)this.seenQueryAndValues.get(this.current)).getID());
                                }
                                if (this.duplicateQuery) {
                                    result.append(" duplicates text of #" + ((QueryInfo)this.seenQuery.get(this.current.getQuery())).getID());
                                }
                                return result.toString();
                            }
                            case 1: {
                                return this.current.getTime() + " ms";
                            }
                            case 2: {
                                return this.current.getConnectionID() + "";
                            }
                            case 3: {
                                return "<blockquote><pre>" + this.current.getQuery() + "</pre><br>BINDS: " + this.current.getBindvars() + "</blockquote>";
                            }
                            case 4: {
                                return this.current.getSQLE();
                            }
                        }
                        return null;
                    }

                    public Object getKeyAt(int columnIndex) {
                        return new Integer(this.current.getID());
                    }
                };
            }

            static /* synthetic */ Dispatcher access$200(10 x0) {
                return x0.Dispatcher.this;
            }
        };
        Table table = new Table((TableModelBuilder)b, headers);
        table.setBorder("1");
        table.getColumn(3).setCellRenderer(new NonEscapedTableCellRenderer());
        table.getColumn(0).setCellRenderer(new DefaultTableCellRenderer(true));
        table.addTableActionListener(new TableActionAdapter(){

            public void cellSelected(TableActionEvent e) {
                PageState s = e.getPageState();
                Integer request_id = (Integer)s.getValue(Dispatcher.this.m_query_request_id);
                ParameterMap params = new ParameterMap();
                params.setParameter("request_id", request_id);
                params.setParameter("query_id", e.getRowKey());
                if (e.getColumn() == 0) {
                    throw new RedirectSignal(URL.getDispatcherPath() + "/ds/query-info" + params, true);
                }
                throw new RedirectSignal(URL.getDispatcherPath() + "/ds/query-log" + params, true);
            }
        });
        Label l = new Label("None");
        l.setFontWeight("i");
        l.setStyleAttr("padding-left: 3em");
        table.setEmptyView(l);
        table.setWidth("100%");
        BoxPanel panel = new BoxPanel(2);
        panel.add(table);
        AbstractTableModelBuilder scoreBuilder = new AbstractTableModelBuilder(){

            public TableModel makeModel(Table t, PageState state) {
                return new TableModel(this, state){
                    Map map;
                    Iterator iter;
                    Integer key;
                    Integer[] row;
                    private final /* synthetic */ PageState val$state;
                    private final /* synthetic */ 13 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$state = val$state;
                        this.map = (Map)Dispatcher.access$600(13.access$500(this.this$1)).get(this.val$state);
                        this.iter = this.map.keySet().iterator();
                    }

                    public int getColumnCount() {
                        return 3;
                    }

                    public boolean nextRow() {
                        if (this.iter.hasNext()) {
                            this.key = (Integer)this.iter.next();
                            this.row = (Integer[])this.map.get(this.key);
                            return true;
                        }
                        return false;
                    }

                    public Object getElementAt(int column) {
                        switch (column) {
                            case 0: {
                                return this.key;
                            }
                            case 1: {
                                return this.row[0];
                            }
                            case 2: {
                                return this.row[1];
                            }
                        }
                        return null;
                    }

                    public Object getKeyAt(int column) {
                        return this.key;
                    }
                };
            }

            static /* synthetic */ Dispatcher access$500(13 x0) {
                return x0.Dispatcher.this;
            }
        };
        Object[] scoreHeaders = new String[]{"ID", "Duplicates", "Text-Duplicates"};
        Table scoreTable = new Table((TableModelBuilder)scoreBuilder, scoreHeaders);
        panel.add(scoreTable);
        return panel;
    }

    private Table makeRequestTable() {
        Object[] headers = new String[]{"Time", "Duration", "Queries", "IP", "Request", "Extra"};
        AbstractTableModelBuilder b = new AbstractTableModelBuilder(){

            public TableModel makeModel(Table t, PageState s) {
                return new TableModel(this){
                    ListIterator iter;
                    private RequestInfo current;
                    static final int MAXSTR = 35;
                    private final /* synthetic */ 15 this$1;
                    {
                        this.this$1 = this$1;
                        this.iter = WebDevSupport.getInstance().getRequestsReverse();
                        this.current = null;
                    }

                    public int getColumnCount() {
                        return 6;
                    }

                    public boolean nextRow() {
                        while (this.iter.hasPrevious()) {
                            this.current = (RequestInfo)this.iter.previous();
                            boolean isdevsupp = this.current.isDevSupportRequest();
                            if (!Dispatcher.access$000() && isdevsupp) continue;
                            return true;
                        }
                        return false;
                    }

                    public Object getElementAt(int columnIndex) {
                        switch (columnIndex) {
                            case 0: {
                                return this.current.getTime();
                            }
                            case 1: {
                                return this.current.getDuration();
                            }
                            case 2: {
                                return this.current.getNumQueries() + "";
                            }
                            case 3: {
                                return this.current.getIP();
                            }
                            case 4: {
                                String req = this.current.getRequest();
                                if (req.length() > 35) {
                                    return req.substring(0, 35) + "...";
                                }
                                return req;
                            }
                            case 5: {
                                return "[query log]";
                            }
                        }
                        return null;
                    }

                    public Object getKeyAt(int columnIndex) {
                        return new Integer(this.current.getID());
                    }
                };
            }
        };
        Table result = new Table((TableModelBuilder)b, headers);
        result.getColumn(4).setCellRenderer(new DefaultTableCellRenderer(true));
        result.getColumn(5).setCellRenderer(new DefaultTableCellRenderer(true));
        result.addTableActionListener(new TableActionAdapter(){

            public void cellSelected(TableActionEvent e) {
                ParameterMap params = new ParameterMap();
                params.setParameter("request_id", e.getRowKey());
                if (e.getColumn() == 4) {
                    throw new RedirectSignal(URL.getDispatcherPath() + "/ds/request-info" + params, true);
                }
                if (e.getColumn() == 5) {
                    throw new RedirectSignal(URL.getDispatcherPath() + "/ds/query-log" + params, true);
                }
            }
        });
        Label l = new Label("None");
        l.setFontWeight("i");
        l.setStyleAttr("padding-left: 3em");
        result.setEmptyView(l);
        result.setWidth("100%");
        return result;
    }

    String dashes(int depth) {
        StringBuffer sb = new StringBuffer();
        while (depth-- > 0) {
            sb.append("--");
        }
        return sb.toString();
    }

    private Page buildQueryPlanPage() {
        Page p = PageFactory.buildPage(APP_NAME, "Query Execution Plan");
        p.addGlobalStateParam(this.m_query_p_request_id);
        p.addGlobalStateParam(this.m_query_p_id);
        p.add(new QueryPlanComponent());
        p.lock();
        return p;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ void access$300(Dispatcher x0, PageState x1, QueryInfo x2, int x3) {
        x0.incrementScore(x1, x2, x3);
    }

    static /* synthetic */ RequestLocal access$600(Dispatcher x0) {
        return x0.m_scoreboard;
    }

    class QueryInfoComponent
    extends SimpleComponent {
        public void generateXML(PageState state, Element parent) {
            QueryInfo qi;
            Integer request_id = (Integer)state.getValue(Dispatcher.this.m_query_request_id);
            Integer query_id = (Integer)state.getValue(Dispatcher.this.m_query_id);
            RequestInfo ri = WebDevSupport.getInstance().getRequest(request_id);
            if (ri != null && (qi = ri.getQuery(query_id)) != null) {
                BoxPanel bp = new BoxPanel();
                ListPanel info_list = new ListPanel(false);
                bp.add(info_list);
                info_list.add(new Label("Execution Time: " + qi.getTime() + " ms"));
                info_list.add(new Label("Connection ID: " + qi.getConnectionID()));
                info_list.add(new Label("Type: " + qi.getType()));
                info_list.add(new Label("Query: <br/><pre>" + StringUtils.quoteHtml(qi.getQuery()) + "</pre>", false));
                info_list.add(new Label("Bindvars: " + qi.getBindvars()));
                Link l = new Link("Query Execution Plan", "../query-plan/");
                l.setVar("request_id", request_id.toString());
                l.setVar("query_id", query_id.toString());
                info_list.add(l);
                info_list.add(new Label("Exception: " + qi.getSQLE()));
                info_list.add(new Label("StackTrace: <br/><pre>" + StringUtils.quoteHtml(qi.getStackTrace()) + "</pre>", false));
                bp.generateXML(state, parent);
            }
        }
    }

    class RequestInfoComponent
    extends SimpleComponent {
        public void generateXML(PageState state, Element parent) {
            Integer request_id = (Integer)state.getValue(Dispatcher.this.m_request_id);
            RequestInfo ri = WebDevSupport.getInstance().getRequest(request_id);
            if (ri != null) {
                BoxPanel bp = new BoxPanel();
                bp.add(new Label("<h3>Parameters</h3>", false));
                ColumnPanel param_list = new ColumnPanel(2);
                bp.add(param_list);
                param_list.add(new Label("Request Start Time:"));
                param_list.add(new Label(ri.getTime()));
                param_list.add(new Label("Request Completion Time: "));
                param_list.add(new Label(ri.getEndTime()));
                param_list.add(new Label("Request Duration: "));
                param_list.add(new Label(ri.getDuration()));
                param_list.add(new Label("IP: "));
                param_list.add(new Label(ri.getIP()));
                param_list.add(new Label("Method: "));
                param_list.add(new Label(ri.getMethod()));
                param_list.add(new Label("URL: "));
                param_list.add(new Label(ri.getURL()));
                param_list.add(new Label("Query: "));
                param_list.add(new Label(StringUtils.quoteHtml(ri.getQuery())));
                param_list.add(new Label("Request Parameters: "));
                ColumnPanel form_list = new ColumnPanel(2);
                param_list.add(form_list);
                Iterator iter = ri.getParameterNames();
                while (iter.hasNext()) {
                    String param = (String)iter.next();
                    form_list.add(new Label(param + ":"));
                    form_list.add(new Label(ri.getParameter(param)));
                }
                bp.add(new Label("<h3>Headers</h3>", false));
                ColumnPanel headers_list = new ColumnPanel(2);
                bp.add(headers_list);
                iter = ri.headerKeys();
                while (iter.hasNext()) {
                    String header = (String)iter.next();
                    headers_list.add(new Label(header + ": "));
                    headers_list.add(new Label(ri.getHeader(header)));
                }
                if (ri.numComments() > 0) {
                    bp.add(new Label("<h3>Comments</h3>", false));
                    ListPanel comment_list = new ListPanel(false);
                    bp.add(comment_list);
                    iter = ri.getComments();
                    while (iter.hasNext()) {
                        comment_list.add(new Label((String)iter.next()));
                    }
                }
                if (ri.numStages() > 0) {
                    bp.add(new Label("<h3>Stages</h3>", false));
                    ColumnPanel stages_list = new ColumnPanel(4);
                    bp.add(stages_list);
                    iter = ri.getStages();
                    stages_list.add(new Label("Stage"));
                    stages_list.add(new Label("Time"));
                    stages_list.add(new Label("Queries"));
                    stages_list.add(new Label("Processing"));
                    while (iter.hasNext()) {
                        StageInfo si = (StageInfo)iter.next();
                        String leaf = si.leaf() ? "*" : "";
                        int numqueries = si.numQueries();
                        long time = si.time();
                        stages_list.add(new Label(Dispatcher.this.dashes(si.depth()) + si.getName()));
                        stages_list.add(new Label(time + " ms" + leaf));
                        if (numqueries != 0) {
                            long queryTime = si.queryTime(ri.getQueries());
                            long non_queryTime = time - queryTime;
                            stages_list.add(new Label(queryTime + " ms" + leaf + " (" + numqueries + " queries)"));
                            stages_list.add(new Label(non_queryTime + " ms" + leaf));
                            continue;
                        }
                        stages_list.add(new Label(""));
                        stages_list.add(new Label(time + " ms" + leaf));
                    }
                }
                bp.add(new Label("<h3>Database Requests</h3>", false));
                int query_count = 0;
                long total_time = 0L;
                iter = ri.getQueries();
                while (iter.hasNext()) {
                    ++query_count;
                    total_time += ((QueryInfo)iter.next()).getTime();
                }
                bp.add(new Label("Total Queries: " + query_count));
                bp.add(new Label("Total Time: " + total_time + " ms"));
                bp.generateXML(state, parent);
            }
        }
    }
}

