/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.webdevsupport;

import com.arsdigita.developersupport.DeveloperSupportListener;
import com.arsdigita.dispatcher.RequestEvent;
import com.arsdigita.webdevsupport.QueryInfo;
import com.arsdigita.webdevsupport.RequestInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;

public class WebDevSupport
extends DeveloperSupportListener {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/webdevsupport/WebDevSupport.java#10 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static WebDevSupport s_instance;
    private static int s_max_requests;
    private HashMap m_threadRequestMap = new HashMap();
    private ArrayList m_requests = new ArrayList();

    public static synchronized WebDevSupport getInstance() {
        if (s_instance == null) {
            s_instance = new WebDevSupport();
        }
        return s_instance;
    }

    private WebDevSupport() {
    }

    public void setMaxRequests(int max_requests) {
        s_max_requests = max_requests;
    }

    public int getMaxRequests() {
        return s_max_requests;
    }

    private synchronized void registerNewRequest(RequestInfo ri) {
        this.m_threadRequestMap.put(Thread.currentThread(), ri);
        this.m_requests.add(ri);
        if (s_max_requests != -1) {
            int to_remove = this.m_requests.size() - s_max_requests;
            for (int i = 0; i < to_remove; ++i) {
                this.m_requests.remove(0);
            }
        }
    }

    synchronized void clearRequestHistory() {
        this.m_requests.clear();
    }

    private RequestInfo getCurrentRequest() {
        return (RequestInfo)this.m_threadRequestMap.get(Thread.currentThread());
    }

    private synchronized void unRegisterRequest() {
        this.m_threadRequestMap.remove(Thread.currentThread());
    }

    public ListIterator getRequestsReverse() {
        ArrayList lst = (ArrayList)this.m_requests.clone();
        return lst.listIterator(lst.size());
    }

    public ListIterator getRequests() {
        ArrayList lst = (ArrayList)this.m_requests.clone();
        return lst.listIterator();
    }

    public RequestInfo getRequest(int id) {
        Iterator iter = this.m_requests.iterator();
        while (iter.hasNext()) {
            RequestInfo ri = (RequestInfo)iter.next();
            if (ri.getID() != id) continue;
            return ri;
        }
        return null;
    }

    public void requestStart(Object request) {
        if (request instanceof RequestEvent && this.getCurrentRequest() == null) {
            this.registerNewRequest(new RequestInfo((RequestEvent)request));
        }
    }

    public void requestAddProperty(Object request, String property, Object value) {
        RequestInfo ri = this.getCurrentRequest();
        if (ri != null) {
            ri.addProperty(property, value);
        }
    }

    public void requestEnd(Object request) {
        RequestInfo ri = this.getCurrentRequest();
        if (ri != null) {
            ri.finish();
        }
        this.unRegisterRequest();
    }

    public void logQuery(int connection_id, String type, String query, HashMap bindvars, long time, SQLException sqle) {
        RequestInfo ri = this.getCurrentRequest();
        if (ri != null) {
            ri.logQuery(new QueryInfo(ri.numQueries() + 1, connection_id, type, query, bindvars, time, sqle));
        }
    }

    public void logComment(String comment) {
        RequestInfo ri = this.getCurrentRequest();
        if (ri != null) {
            ri.logComment(comment);
        }
    }

    public void startStage(String stagename) {
        RequestInfo ri = this.getCurrentRequest();
        if (ri != null) {
            ri.startStage(stagename);
        }
    }

    public void endStage(String stagename) {
        RequestInfo ri = this.getCurrentRequest();
        if (ri != null) {
            ri.endStage(stagename);
        }
    }

    static {
        s_max_requests = 100;
    }
}

