/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.workflow.simple;

import java.io.PrintStream;
import java.util.Date;

public class Duration {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/workflow/simple/Duration.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private int m_duration = 0;
    private Date m_startDate = new Date();

    public Duration(int days, int hours, int minutes) {
        this.setDuration(days, hours, minutes);
    }

    public Duration(int minutes) {
        this.setDuration(minutes);
    }

    public Duration(Date startDate) {
        this.m_startDate = (Date)startDate.clone();
    }

    public Duration(Date startDate, int days, int hours, int minutes) {
        this.m_startDate = (Date)startDate.clone();
        this.setDuration(days, hours, minutes);
    }

    public Duration(Date startDate, int minutes) {
        this.m_startDate = (Date)startDate.clone();
        this.setDuration(minutes);
    }

    public void setDuration(int days, int hours, int minutes) {
        this.setDuration(days * 24 * 60 + hours * 60 + minutes);
    }

    public void setDuration(int minutes) {
        this.m_duration = minutes;
    }

    public Date getStartDate() {
        return this.m_startDate;
    }

    public Date getDueDate() {
        return new Date(this.m_startDate.getTime() + (long)(this.m_duration * 60 * 1000));
    }

    public int getDuration() {
        return this.m_duration;
    }

    public boolean isPassedOverDue() {
        Date curr_date = new Date();
        return curr_date.after(this.getDueDate());
    }

    public boolean isPassedOverDue(Date date) {
        return date.after(this.getDueDate());
    }

    public void printSummary(PrintStream out) throws Exception {
        out.print("Start Date: " + this.getStartDate() + "\n");
        out.print("Duration  : " + this.getDuration() + " [m_duration]\n");
        out.print("Due   Date: " + this.getDueDate() + "\n");
    }

    public static void main(String[] arg) {
        try {
            System.out.println("set a process to start now , lasting 1d, 1h, 1 min, and print summary");
            Duration d = new Duration(new Date(), 1, 1, 1);
            d.printSummary(System.out);
            System.out.println("Change duration to 10 days , 100 hours, 1000 minutes");
            d.setDuration(10, 100, 1000);
            d.printSummary(System.out);
            System.out.println("Set startDate to old dueDate and set  duration to -10 days, -100 hours, -1000 mins");
            d = new Duration(d.getDueDate(), -10, -100, -1000);
            d.printSummary(System.out);
            System.out.println("Reset duration to 10 days, 100 hours,  1000 minutes and reset startDate to tomorrow");
            d.setDuration(10, 100, 1000);
        }
        catch (Exception e) {
            System.out.println("Something happened: " + e);
        }
    }
}

