/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.workflow.simple;

import com.arsdigita.auditing.AuditedACSObject;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.User;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.workflow.simple.ProcessException;
import com.arsdigita.workflow.simple.TaskCollection;
import com.arsdigita.workflow.simple.TaskComment;
import com.arsdigita.workflow.simple.TaskException;
import com.arsdigita.workflow.simple.Workflow;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class Task
extends AuditedACSObject
implements Cloneable {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/workflow/simple/Task.java#19 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.workflow.simple.Task";
    static final String LABEL = "label";
    static final String DESCRIPTION = "description";
    static final String IS_ACTIVE = "isActive";
    static final String DEPENDENCY_LIST = "dependsOn";
    static final String PARENT_TASK_ID = "parentTaskID";
    static final String COMMENTS = "comments";
    static final String TASK_STATE = "taskState";
    static final String FINISHED_LISTENERS = "taskFinishedListeners";
    static final String DEFAULT_DESCRIPTION = "none";
    static final String DEFAULT_LABEL = "none";
    public static final int DISABLED = 0;
    public static final int ENABLED = 1;
    public static final int FINISHED = 2;
    public static final int DELETED = 3;
    public static final int INACTIVE = 4;
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$workflow$simple$Task == null ? (class$com$arsdigita$workflow$simple$Task = Task.class$("com.arsdigita.workflow.simple.Task")) : class$com$arsdigita$workflow$simple$Task));
    static /* synthetic */ Class class$com$arsdigita$workflow$simple$Task;

    public Task(String label, String description) {
        this(BASE_DATA_OBJECT_TYPE);
        this.initAttributes(label, description);
    }

    public Task(DataObject taskDataObject) {
        super(taskDataObject);
    }

    public Task() {
        this(BASE_DATA_OBJECT_TYPE);
        this.setState(0);
    }

    public Task(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public Task(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    protected Task(ObjectType type) {
        super(type);
    }

    protected Task(String typeName) {
        super(typeName);
    }

    protected void initialize() {
        super.initialize();
        if (this.isNew()) {
            this.setLabel("none");
            this.setDescription("none");
            this.setState(0);
            this.set(IS_ACTIVE, Boolean.FALSE);
        }
    }

    protected void initAttributes(String label, String description) {
        this.setLabel(label);
        this.setDescription(description);
    }

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    private static ObjectType getObjectType(String typeName) {
        return SessionManager.getMetadataRoot().getObjectType(typeName);
    }

    public void setLabel(String label) {
        this.set(LABEL, label);
    }

    public String getLabel() {
        return (String)this.get(LABEL);
    }

    public String getStateString() {
        return (String)this.get(TASK_STATE);
    }

    public void setDescription(String description) {
        this.set(DESCRIPTION, description);
    }

    public String getDescription() {
        return (String)this.get(DESCRIPTION);
    }

    public void setActive(boolean isActive) {
        boolean currentIsActive = this.isActive();
        if (currentIsActive != isActive) {
            this.set(IS_ACTIVE, isActive ? Boolean.TRUE : Boolean.FALSE);
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Setting task " + this.getID() + " to " + isActive));
            }
            if (!this.isNew()) {
                this.save();
            }
        }
        this.triggerListenerUpdateState();
    }

    public boolean isActive() {
        return (Boolean)this.get(IS_ACTIVE);
    }

    public BigDecimal getParentID() {
        return (BigDecimal)this.get(PARENT_TASK_ID);
    }

    public Workflow getWorkflow() {
        BigDecimal workflowID = this.getParentID();
        if (workflowID != null) {
            try {
                return (Workflow)DomainObjectFactory.newInstance(new OID("com.arsdigita.workflow.simple.Workflow", (Object)workflowID));
            }
            catch (DataObjectNotFoundException de) {
                throw new UncheckedWrapperException("Could not load Workflow with ID " + workflowID, de);
            }
        }
        return null;
    }

    void setParent(Workflow parent) {
        this.setParentID(parent.getID());
    }

    void setParentID(BigDecimal id) {
        this.set(PARENT_TASK_ID, id);
    }

    private DataAssociation getDependsOnAssociation() {
        return (DataAssociation)this.get(DEPENDENCY_LIST);
    }

    public Iterator getDependencies() {
        return this.getDependenciesInternal().iterator();
    }

    public final TaskCollection getRequiredTasks() {
        return new TaskCollection(this.getDependsOnAssociation());
    }

    private Collection getDependenciesInternal() {
        HashSet<Task> dependencies = new HashSet<Task>();
        TaskCollection dependsOn = new TaskCollection(this.getDependsOnAssociation().cursor());
        while (dependsOn.next()) {
            if (dependsOn.getTask() == null) continue;
            dependencies.add(dependsOn.getTask());
        }
        dependsOn.close();
        return dependencies;
    }

    public boolean addDependency(Task task) {
        if (this.getDependenciesInternal().contains(task)) {
            return false;
        }
        HashSet<Task> alreadyVisited = new HashSet<Task>();
        alreadyVisited.add(task);
        alreadyVisited.add(this);
        if (this.hasLoop(task, alreadyVisited)) {
            return false;
        }
        this.add(DEPENDENCY_LIST, task);
        this.notifyAddDependency(task);
        this.save();
        this.updateState();
        return true;
    }

    public void removeDependency(Task task) {
        this.remove(DEPENDENCY_LIST, task);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Removed dependency " + task.getID() + " for " + this.getID()));
        }
        this.notifyRemoveDependency(task);
        this.updateState();
    }

    public boolean isDependency(Task task) {
        return this.getDependenciesInternal().contains(task);
    }

    private void notifyRemoveDependency(Task task) {
        task.removeFinishedListener(this);
    }

    private void notifyAddDependency(Task task) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Adding finish listener for " + task.getID() + " for task " + this.getID()));
        }
        task.addFinishedListener(this);
        if (this.isNew()) {
            this.save();
        }
        task.save();
    }

    public void removeAllDependencies() {
        Iterator iter = this.getDependencies();
        while (iter.hasNext()) {
            Task task = (Task)iter.next();
            this.remove(DEPENDENCY_LIST, task);
            this.notifyRemoveDependency(task);
        }
    }

    public void removeAllFinishedListeners() {
        Iterator iter = this.getFinishedListeners();
        while (iter.hasNext()) {
            Task task = (Task)iter.next();
            this.remove(FINISHED_LISTENERS, task);
        }
    }

    public int getDependencyCount() {
        return new Long(this.getDependsOnAssociation().cursor().size()).intValue();
    }

    private boolean hasLoop(Task currTask, HashSet alreadyVisited) {
        Iterator dep_iter = currTask.getDependencies();
        while (dep_iter.hasNext()) {
            Task task = (Task)dep_iter.next();
            if (alreadyVisited.contains(task)) {
                return true;
            }
            alreadyVisited.add(task);
            if (this.hasLoop(task, alreadyVisited)) {
                return true;
            }
            alreadyVisited.remove(task);
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof Task) {
            return ((Task)object).getID().equals(this.getID());
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        Task taskClone = new Task();
        this.copyAttributes(taskClone);
        return taskClone;
    }

    protected void copyAttributes(Task task) {
        task.setLabel(this.getLabel());
        task.setDescription(this.getDescription());
        task.setActive(this.isActive());
    }

    public String toString() {
        return this.getOID().toString();
    }

    public void addComment(TaskComment c) {
        if (!this.getCommentsInternal().contains(c)) {
            c.setTask(this);
            this.add(COMMENTS, c);
        }
    }

    public void addComment(User user, String comment) {
        this.addComment(new TaskComment(this.getID(), user, comment));
    }

    public void addComment(String comment) {
        this.addComment(null, comment);
    }

    public void removeComment(TaskComment taskComment) {
        this.remove(COMMENTS, taskComment);
    }

    public Iterator getComments() {
        return this.getCommentsInternal().iterator();
    }

    public int getCommentsSize() {
        return this.getCommentsInternal().size();
    }

    private Collection getCommentsInternal() {
        ArrayList<TaskComment> comments = new ArrayList<TaskComment>();
        DataAssociationCursor commentDataAssociation = this.getCommentAssociation().cursor();
        while (commentDataAssociation.next()) {
            comments.add(new TaskComment(commentDataAssociation.getDataObject()));
        }
        commentDataAssociation.close();
        return comments;
    }

    private DataAssociation getCommentAssociation() {
        return (DataAssociation)this.get(COMMENTS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TaskComment getLastComment() {
        DataAssociationCursor comments = this.getCommentAssociation().cursor();
        comments.addOrder("commentDate desc");
        try {
            if (comments.next()) {
                TaskComment taskComment = (TaskComment)DomainObjectFactory.newInstance(comments.getDataObject());
                return taskComment;
            }
            TaskComment taskComment = null;
            return taskComment;
        }
        finally {
            comments.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TaskComment getLastCommentInWorkflow() {
        DataQuery query = SessionManager.getSession().retrieveQuery("com.arsdigita.workflow.simple.getCommentsInWorkflow");
        query.addOrder("comment.commentDate desc");
        query.setParameter("taskID", this.getID());
        try {
            if (query.next()) {
                TaskComment taskComment = (TaskComment)DomainObjectFactory.newInstance((DataObject)query.get("comment"));
                return taskComment;
            }
            TaskComment taskComment = null;
            return taskComment;
        }
        finally {
            query.close();
        }
    }

    public Iterator getFinishedListeners() {
        return this.getFinishedListenersInternal().iterator();
    }

    protected Collection getFinishedListenersInternal() {
        HashSet<Task> listeners = new HashSet<Task>();
        TaskCollection tasksCollection = new TaskCollection((DataAssociation)this.get(FINISHED_LISTENERS));
        while (tasksCollection.next()) {
            listeners.add(tasksCollection.getTask());
        }
        tasksCollection.close();
        return listeners;
    }

    public void addFinishedListener(Task task) {
        this.add(FINISHED_LISTENERS, task);
    }

    public void removeFinishedListener(Task task) {
        this.remove(FINISHED_LISTENERS, task);
    }

    public int getFinishedListenersCount() {
        DataAssociation da = (DataAssociation)this.get(FINISHED_LISTENERS);
        return new Long(da.cursor().size()).intValue();
    }

    public void enable() {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Enabling task '" + this.getLabel() + "'"));
        }
        this.checkEnableProcess();
        if (this.getState() == 0) {
            s_log.debug((Object)"The task is disabled; enabling it");
            this.setState(1);
            this.save();
            this.enableEvt();
        } else if (this.getState() == 2) {
            s_log.debug((Object)"The task is finished; reenabling it");
            this.setState(1);
            this.save();
            this.enableEvt();
            this.triggerListenerUpdateState();
        } else {
            s_log.debug((Object)("The task is in state '" + this.getStateString() + "'; " + "doing nothing"));
        }
    }

    public void disable() {
        this.checkEnableProcess();
        int currState = this.getState();
        if (currState == 0) {
            return;
        }
        this.setState(0);
        this.save();
        if (currState == 2) {
            this.rollbackEvt();
            this.triggerListenerUpdateState();
        } else if (currState == 1) {
            this.disableEvt();
        }
    }

    private void triggerListenerUpdateState() {
        Iterator finishedListeners = this.getFinishedListeners();
        Task tempTask = null;
        while (finishedListeners.hasNext()) {
            tempTask = (Task)finishedListeners.next();
            tempTask.updateState();
        }
    }

    private void checkEnableProcess() {
    }

    public int getState() {
        return Task.getStateMapping(this.getStateString());
    }

    public void setState(int state) {
        this.set(TASK_STATE, Task.getStateString(state));
    }

    public static String getStateString(int state) {
        switch (state) {
            case 1: {
                return "enabled";
            }
            case 0: {
                return "disabled";
            }
            case 2: {
                return "finished";
            }
            case 3: {
                return "deleted";
            }
        }
        return null;
    }

    public static int getStateMapping(String taskState) {
        if (taskState.compareTo("enabled") == 0) {
            return 1;
        }
        if (taskState.compareTo("disabled") == 0) {
            return 0;
        }
        if (taskState.compareTo("finished") == 0) {
            return 2;
        }
        if (taskState.compareTo("deleted") == 0) {
            return 3;
        }
        return 0;
    }

    public void finish() throws TaskException {
        this.checkEnableProcess();
        if (!this.isEnabled()) {
            throw new TaskException("Task is not enabled");
        }
        this.setState(2);
        this.save();
        this.finishEvt();
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Task finished" + this.getID()));
            s_log.debug((Object)("Task state finished is " + this.isFinished()));
            s_log.debug((Object)("Task active state is " + this.isActive()));
        }
        Iterator finishedListeners = this.getFinishedListeners();
        try {
            while (finishedListeners.hasNext()) {
                Task tempTask = (Task)finishedListeners.next();
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("preNotifyFinished listeners " + tempTask.getID()));
                }
                tempTask.notifyFinished(this);
                if (!s_log.isDebugEnabled()) continue;
                s_log.debug((Object)("processing listeners " + tempTask.getID()));
            }
        }
        catch (TaskException taskException) {
            taskException.printStackTrace();
            s_log.debug((Object)("setting state to be enabled " + this.getID()));
            this.setState(1);
        }
    }

    public boolean isEnabled() {
        return this.getState() == 1;
    }

    public boolean isFinished() {
        return this.getState() == 2;
    }

    synchronized void updateState() {
        boolean dependenciesSatisfied = true;
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Updating state for " + this.getID() + " " + this.getLabel()));
        }
        if (this.getState() == 3 || !this.isActive()) {
            return;
        }
        Iterator dependencies = this.getDependencies();
        while (dependencies.hasNext()) {
            Task dependsOnTask = (Task)dependencies.next();
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Checking dependency " + dependsOnTask.getID() + " for " + this.getID()));
            }
            if (dependsOnTask.isFinished() || !dependsOnTask.isActive()) continue;
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Dependency not yet satisfied: " + dependsOnTask.getID()));
                s_log.debug((Object)("Dependency finished state: " + dependsOnTask.isFinished()));
                s_log.debug((Object)("Dependency active state: " + dependsOnTask.isActive()));
            }
            dependenciesSatisfied = false;
            break;
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("dependencies state is " + dependenciesSatisfied + " for " + this.getID()));
            s_log.debug((Object)("the state is " + this.getState()));
        }
        if (this.getState() == 2) {
            if (!dependenciesSatisfied) {
                this.disable();
                return;
            }
            this.enable();
            return;
        }
        if (this.getState() == 1 && !dependenciesSatisfied) {
            this.disable();
            return;
        }
        if (this.getState() == 0 && dependenciesSatisfied) {
            this.enable();
            return;
        }
    }

    public void notifyFinished(Task senderTask) throws TaskException, ProcessException {
        this.updateState();
    }

    public void delete() {
        this.triggerListenerUpdateState();
        super.delete();
    }

    public String getDisplayName() {
        return this.getLabel();
    }

    protected void rollbackEvt() {
    }

    protected void enableEvt() {
    }

    protected void disableEvt() {
    }

    protected void finishEvt() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

