/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.xml;

import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Element {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/xml/Element.java#16 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((String)(class$com$arsdigita$xml$Element == null ? (class$com$arsdigita$xml$Element = Element.class$("com.arsdigita.xml.Element")) : class$com$arsdigita$xml$Element).getName());
    protected org.w3c.dom.Element m_element;
    private Document m_doc;
    private static ThreadLocal s_localDocument = new ThreadLocal(){

        public Object initialValue() {
            try {
                DocumentBuilderFactory builder = DocumentBuilderFactory.newInstance();
                builder.setNamespaceAware(true);
                return builder.newDocumentBuilder().newDocument();
            }
            catch (ParserConfigurationException e) {
                s_log.error((Object)e);
                throw new UncheckedWrapperException("INTERNAL: Could not create thread local DOM document.", e);
            }
        }
    };
    static /* synthetic */ Class class$com$arsdigita$xml$Element;
    static /* synthetic */ Class class$java$lang$String;

    private static Document getDocument() {
        return (Document)s_localDocument.get();
    }

    protected Element() {
    }

    public Element(String name) {
        this();
        Assert.exists(name, class$java$lang$String == null ? (class$java$lang$String = Element.class$("java.lang.String")) : class$java$lang$String);
        this.m_element = Element.getDocument().createElement(name);
    }

    public Element(String name, String uri) {
        Assert.exists(name, class$java$lang$String == null ? (class$java$lang$String = Element.class$("java.lang.String")) : class$java$lang$String);
        Assert.exists(uri, class$java$lang$String == null ? (class$java$lang$String = Element.class$("java.lang.String")) : class$java$lang$String);
        this.m_element = Element.getDocument().createElementNS(uri, name);
    }

    public Element newChildElement(String name) {
        Assert.exists(name, class$java$lang$String == null ? (class$java$lang$String = Element.class$("java.lang.String")) : class$java$lang$String);
        if (this.m_doc == null) {
            this.m_doc = this.m_element.getOwnerDocument();
        }
        Element result = new Element();
        result.m_element = this.m_doc.createElement(name);
        this.m_element.appendChild(result.m_element);
        return result;
    }

    public Element newChildElement(String name, String uri) {
        Assert.exists(name, class$java$lang$String == null ? (class$java$lang$String = Element.class$("java.lang.String")) : class$java$lang$String);
        Assert.exists(uri, class$java$lang$String == null ? (class$java$lang$String = Element.class$("java.lang.String")) : class$java$lang$String);
        if (this.m_doc == null) {
            this.m_doc = this.m_element.getOwnerDocument();
        }
        Element result = new Element();
        result.m_element = this.m_doc.createElementNS(uri, name);
        this.m_element.appendChild(result.m_element);
        return result;
    }

    public Element newChildElement(Element copyFrom) {
        Assert.exists(copyFrom, class$com$arsdigita$xml$Element == null ? (class$com$arsdigita$xml$Element = Element.class$("com.arsdigita.xml.Element")) : class$com$arsdigita$xml$Element);
        if (this.m_doc == null) {
            this.m_doc = this.m_element.getOwnerDocument();
        }
        Element copyTo = new Element();
        copyTo.m_element = this.m_doc.createElementNS(copyFrom.m_element.getNamespaceURI(), copyFrom.getName());
        this.m_element.appendChild(copyTo.m_element);
        this.newChildElementHelper(copyFrom, copyTo);
        return copyTo;
    }

    public Element newChildElement(String name, Element copyFrom) {
        if (this.m_doc == null) {
            this.m_doc = this.m_element.getOwnerDocument();
        }
        Element copyTo = new Element();
        copyTo.m_element = this.m_doc.createElement(name);
        this.m_element.appendChild(copyTo.m_element);
        this.newChildElementHelper(copyFrom, copyTo);
        return copyTo;
    }

    public Element newChildElement(String name, String uri, Element copyFrom) {
        if (this.m_doc == null) {
            this.m_doc = this.m_element.getOwnerDocument();
        }
        Element copyTo = new Element();
        copyTo.m_element = this.m_doc.createElementNS(uri, name);
        this.m_element.appendChild(copyTo.m_element);
        this.newChildElementHelper(copyFrom, copyTo);
        return copyTo;
    }

    private void newChildElementHelper(Element copyFrom, Element copyTo) {
        copyTo.setText(copyFrom.getText());
        NamedNodeMap nnm = copyFrom.m_element.getAttributes();
        if (nnm != null) {
            for (int i = 0; i < nnm.getLength(); ++i) {
                Attr attr = (Attr)nnm.item(i);
                copyTo.addAttribute(attr.getName(), attr.getValue());
            }
        }
        Iterator iter = copyFrom.getChildren().iterator();
        while (iter.hasNext()) {
            Element child = (Element)iter.next();
            copyTo.newChildElement(child);
        }
    }

    public Element addAttribute(String name, String value) {
        Assert.exists(name, class$java$lang$String == null ? (class$java$lang$String = Element.class$("java.lang.String")) : class$java$lang$String);
        this.m_element.setAttribute(name, value);
        return this;
    }

    public Element addAttribute(String name, String value, String ns) {
        Assert.exists(name, class$java$lang$String == null ? (class$java$lang$String = Element.class$("java.lang.String")) : class$java$lang$String);
        Assert.exists(ns, class$java$lang$String == null ? (class$java$lang$String = Element.class$("java.lang.String")) : class$java$lang$String);
        this.m_element.setAttributeNS(ns, name, value);
        return this;
    }

    public Element addContent(Element newContent) {
        Assert.exists(newContent, class$com$arsdigita$xml$Element == null ? (class$com$arsdigita$xml$Element = Element.class$("com.arsdigita.xml.Element")) : class$com$arsdigita$xml$Element);
        newContent.importInto(this.m_element.getOwnerDocument());
        this.m_element.appendChild(newContent.getInternalElement());
        return this;
    }

    public Element setText(String text) {
        if (text == null) {
            text = "";
        }
        Text textElem = this.m_element.getOwnerDocument().createTextNode(text);
        this.m_element.appendChild(textElem);
        return this;
    }

    public String getText() {
        StringBuffer result = new StringBuffer();
        NodeList nl = this.m_element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 3) continue;
            result.append(((Text)n).getData());
        }
        return result.toString();
    }

    public Element setCDATASection(String cdata) {
        s_log.debug((Object)("Setting CDATA section to '" + cdata + "'."));
        if (cdata == null) {
            cdata = "";
        }
        CDATASection cdataSection = this.m_element.getOwnerDocument().createCDATASection(cdata);
        this.m_element.appendChild(cdataSection);
        return this;
    }

    public String getCDATASection() {
        StringBuffer result = new StringBuffer();
        NodeList nl = this.m_element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 4) continue;
            result.append(((CDATASection)n).getData());
        }
        String str = result.toString();
        s_log.debug((Object)("Fetched this from CDATA section: " + str));
        return str;
    }

    public List getChildren() {
        ArrayList<Element> retval = new ArrayList<Element>();
        NodeList nl = this.m_element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!(n instanceof org.w3c.dom.Element)) continue;
            Element elt = new Element();
            elt.m_element = (org.w3c.dom.Element)n;
            retval.add(elt);
        }
        return retval;
    }

    public Map getAttributes() {
        NamedNodeMap attributeNodeMap = this.m_element.getAttributes();
        HashMap<String, String> returnMap = new HashMap<String, String>();
        for (int i = 0; i < attributeNodeMap.getLength(); ++i) {
            Node attributeNode = attributeNodeMap.item(i);
            returnMap.put(attributeNode.getNodeName(), attributeNode.getNodeValue());
        }
        return returnMap;
    }

    public String getAttribute(String name) {
        return this.m_element.getAttribute(name);
    }

    public boolean hasAttribute(String name) {
        return this.m_element.hasAttribute(name);
    }

    public String getName() {
        return this.m_element.getTagName();
    }

    protected final org.w3c.dom.Element getInternalElement() {
        return this.m_element;
    }

    protected void importInto(Document doc) {
        this.m_element = (org.w3c.dom.Element)doc.importNode(this.m_element, true);
    }

    public static void visitAllAttributes(Node node) {
        NodeList nl;
        NamedNodeMap nnm = node.getAttributes();
        if (nnm != null) {
            for (int i = 0; i < nnm.getLength(); ++i) {
                Attr attr = (Attr)nnm.item(i);
                attr.getValue();
            }
        }
        if ((nl = node.getChildNodes()) != null) {
            for (int i = 0; i < nl.getLength(); ++i) {
                Element.visitAllAttributes(nl.item(i));
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

