/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.xml;

import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.xml.Element;
import com.arsdigita.xml.Formatter;
import com.arsdigita.xml.formatters.DateTimeFormatter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XML {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$xml$XML == null ? (class$com$arsdigita$xml$XML = XML.class$("com.arsdigita.xml.XML")) : class$com$arsdigita$xml$XML));
    private static Map s_formatters = new HashMap();
    static /* synthetic */ Class class$com$arsdigita$xml$XML;
    static /* synthetic */ Class class$java$util$Date;

    private XML() {
    }

    public static void registerFormatter(Class klass, Formatter formatter) {
        s_formatters.put(klass, formatter);
    }

    public static void unregisterFormatter(Class klass) {
        s_formatters.remove(klass);
    }

    public static Formatter getFormatter(Class klass) {
        return (Formatter)s_formatters.get(klass);
    }

    public static Formatter findFormatter(Class klass) {
        Formatter formatter = null;
        while (formatter == null && klass != null) {
            formatter = XML.getFormatter(klass);
            klass = klass.getSuperclass();
        }
        return formatter;
    }

    public static String format(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        Formatter formatter = XML.findFormatter(value.getClass());
        if (formatter == null) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("No formatter for " + value.getClass()));
            }
            return value.toString();
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Processing " + value.getClass() + " with " + formatter.getClass()));
        }
        return formatter.format(value);
    }

    public static final void parseResource(String path, DefaultHandler handler) {
        ClassLoader cload;
        InputStream stream;
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Processing resource " + path + " with " + handler.getClass()));
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((stream = (cload = Thread.currentThread().getContextClassLoader()).getResourceAsStream(path)) == null) {
            throw new IllegalArgumentException("no such resource: " + path);
        }
        XML.parse(stream, handler);
    }

    public static final void parse(InputStream source, DefaultHandler handler) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Processing stream " + source + " with " + handler.getClass()));
        }
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setFeature("http://xml.org/sax/features/namespaces", true);
            SAXParser parser = spf.newSAXParser();
            parser.parse(source, handler);
        }
        catch (ParserConfigurationException e) {
            throw new UncheckedWrapperException("error parsing stream", e);
        }
        catch (SAXException e) {
            if (e.getException() != null) {
                throw new UncheckedWrapperException("error parsing stream", e.getException());
            }
            throw new UncheckedWrapperException("error parsing stream", e);
        }
        catch (IOException e) {
            throw new UncheckedWrapperException("error parsing stream", e);
        }
    }

    public static void toSkeleton(Element element, final PrintWriter writer) {
        XML.traverse(element, 0, new Action(){

            public void apply(Element elem, int level) {
                String padding = "  ";
                for (int ii = 0; ii < level; ++ii) {
                    writer.print("  ");
                }
                writer.print(elem.getName());
                Iterator attrs = elem.getAttributes().keySet().iterator();
                while (attrs.hasNext()) {
                    writer.print(" @");
                    writer.print((String)attrs.next());
                }
                writer.println("");
            }
        });
    }

    public static String toSkeleton(Element element) {
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        XML.toSkeleton(element, pw);
        pw.close();
        return writer.toString();
    }

    public static void traverse(Element elem, int level, Action action) {
        action.apply(elem, level);
        Iterator children = elem.getChildren().iterator();
        while (children.hasNext()) {
            XML.traverse((Element)children.next(), level + 1, action);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        s_formatters.put(class$java$util$Date == null ? (class$java$util$Date = XML.class$("java.util.Date")) : class$java$util$Date, new DateTimeFormatter());
    }

    public static interface Action {
        public void apply(Element var1, int var2);
    }
}

