/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence;

import com.redhat.persistence.AddEvent;
import com.redhat.persistence.CreateEvent;
import com.redhat.persistence.DeleteEvent;
import com.redhat.persistence.Event;
import com.redhat.persistence.ObjectEvent;
import com.redhat.persistence.PropertyEvent;
import com.redhat.persistence.RemoveEvent;
import com.redhat.persistence.Session;
import com.redhat.persistence.SetEvent;
import com.redhat.persistence.common.CompoundKey;
import com.redhat.persistence.metadata.ObjectType;
import com.redhat.persistence.metadata.Property;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

class EventStream {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/EventStream.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private final LinkedList m_events = new LinkedList();
    private final Map m_objectEvents = new HashMap();
    private final Map m_setEvents = new HashMap();
    private final Map m_collectionEvents = new HashMap();
    private final Session m_ssn;
    private final boolean m_coalescing;

    public EventStream(Session ssn) {
        this(ssn, false);
    }

    public EventStream(Session ssn, boolean coalescing) {
        this.m_ssn = ssn;
        this.m_coalescing = coalescing;
    }

    public int size() {
        return this.m_events.size();
    }

    public List getEvents() {
        return this.m_events;
    }

    public Iterator iterator() {
        return this.m_events.iterator();
    }

    public ListIterator listIterator() {
        return this.m_events.listIterator();
    }

    public void clear() {
        this.m_events.clear();
        this.m_objectEvents.clear();
        this.m_setEvents.clear();
        this.m_collectionEvents.clear();
    }

    private Object getKey(Object obj) {
        return this.m_ssn.getSessionKey(obj);
    }

    private Object getKey(Object obj, Property prop) {
        return new CompoundKey(this.m_ssn.getSessionKey(obj), prop);
    }

    public void add(Event ev) {
        this.m_events.add(ev);
        ev.dispatch(new Event.Switch(){

            private void onObjectEvent(ObjectEvent e) {
                EventStream.this.m_objectEvents.put(EventStream.this.getKey(e.getObject()), e);
                ObjectType type = EventStream.this.m_ssn.getObjectType(e.getObject());
                Iterator it = type.getProperties().iterator();
                while (it.hasNext()) {
                    Property prop = (Property)it.next();
                    Object key = EventStream.this.getKey(e.getObject(), prop);
                    if (prop.isCollection()) {
                        if (!EventStream.this.m_collectionEvents.containsKey(key)) continue;
                        EventStream.this.m_collectionEvents.remove(key);
                        continue;
                    }
                    if (!EventStream.this.m_setEvents.containsKey(key)) continue;
                    EventStream.this.m_setEvents.remove(key);
                }
            }

            public void onCreate(CreateEvent e) {
                this.onObjectEvent(e);
            }

            public void onDelete(DeleteEvent e) {
                Object key = EventStream.this.getKey(e.getObject());
                boolean found = false;
                if (EventStream.this.m_coalescing && EventStream.this.getLastEvent(e.getObject()) != null) {
                    CreateEvent ce = (CreateEvent)EventStream.this.getLastEvent(e.getObject());
                    Iterator it = EventStream.this.m_events.iterator();
                    while (it.hasNext()) {
                        PropertyEvent pe;
                        Event ev = (Event)it.next();
                        if (ev.equals(ce)) {
                            found = true;
                        }
                        if (!found) continue;
                        if (EventStream.this.getKey(ev.getObject()).equals(key)) {
                            it.remove();
                            continue;
                        }
                        if (!(ev instanceof PropertyEvent) || !key.equals(EventStream.this.getKey((pe = (PropertyEvent)ev).getArgument()))) continue;
                        it.remove();
                    }
                    if (!found) {
                        throw new IllegalStateException();
                    }
                }
                this.onObjectEvent(e);
                if (EventStream.this.m_coalescing && found) {
                    EventStream.this.m_objectEvents.remove(key);
                    for (int i = EventStream.this.m_events.size() - 1; i >= 0; --i) {
                        DeleteEvent de;
                        if (!(EventStream.this.m_events.get(i) instanceof DeleteEvent) || !key.equals(EventStream.this.getKey((de = (DeleteEvent)EventStream.this.m_events.get(i)).getObject()))) continue;
                        EventStream.this.m_objectEvents.put(key, de);
                        break;
                    }
                }
            }

            public void onSet(SetEvent e) {
                EventStream.this.m_setEvents.put(EventStream.this.getKey(e.getObject(), e.getProperty()), e);
            }

            private void onCollectionEvent(PropertyEvent e) {
                Object key = EventStream.this.getKey(e.getObject(), e.getProperty());
                LinkedList<PropertyEvent> lst = (LinkedList<PropertyEvent>)EventStream.this.m_collectionEvents.get(key);
                if (lst == null) {
                    lst = new LinkedList<PropertyEvent>();
                    EventStream.this.m_collectionEvents.put(key, lst);
                }
                lst.add(e);
            }

            public void onAdd(AddEvent e) {
                this.onCollectionEvent(e);
            }

            public void onRemove(RemoveEvent e) {
                this.onCollectionEvent(e);
            }
        });
    }

    void remove(Event ev) {
        this.m_events.remove(ev);
        ev.dispatch(new Event.Switch(){

            private void onObjectEvent(ObjectEvent e) {
                if (e.equals(EventStream.this.getLastEvent(e.getObject()))) {
                    EventStream.this.m_objectEvents.remove(EventStream.this.getKey(e.getObject()));
                }
            }

            public void onCreate(CreateEvent e) {
                this.onObjectEvent(e);
            }

            public void onDelete(DeleteEvent e) {
                this.onObjectEvent(e);
            }

            public void onSet(SetEvent e) {
                if (e.equals(EventStream.this.getLastEvent(e.getObject(), e.getProperty()))) {
                    EventStream.this.m_setEvents.remove(EventStream.this.getKey(e.getObject(), e.getProperty()));
                }
            }

            private void onCollectionEvent(PropertyEvent e) {
                List lst = (List)EventStream.this.m_collectionEvents.get(EventStream.this.getKey(e.getObject(), e.getProperty()));
                if (lst != null) {
                    lst.remove(e);
                }
            }

            public void onAdd(AddEvent e) {
                this.onCollectionEvent(e);
            }

            public void onRemove(RemoveEvent e) {
                this.onCollectionEvent(e);
            }
        });
    }

    public ObjectEvent getLastEvent(Object obj) {
        if (obj == null) {
            return null;
        }
        return (ObjectEvent)this.m_objectEvents.get(this.getKey(obj));
    }

    public PropertyEvent getLastEvent(Object obj, Property prop) {
        if (prop.isCollection()) {
            LinkedList lst = (LinkedList)this.m_collectionEvents.get(this.getKey(obj, prop));
            if (lst == null) {
                return null;
            }
            return (PropertyEvent)lst.getLast();
        }
        return (PropertyEvent)this.m_setEvents.get(this.getKey(obj, prop));
    }

    public PropertyEvent getLastEvent(Object obj, Property prop, Object arg) {
        if (!prop.isCollection()) {
            throw new IllegalArgumentException();
        }
        List events = (List)this.m_collectionEvents.get(this.getKey(obj, prop));
        if (events == null) {
            return null;
        }
        for (int i = events.size() - 1; i >= 0; --i) {
            PropertyEvent old = (PropertyEvent)events.get(i);
            if (!old.getArgument().equals(arg)) continue;
            return old;
        }
        return null;
    }

    public PropertyEvent getLastEvent(PropertyEvent pe) {
        if (pe.getProperty().isCollection()) {
            return this.getLastEvent(pe.getObject(), pe.getProperty(), pe.getArgument());
        }
        return this.getLastEvent(pe.getObject(), pe.getProperty());
    }

    public Collection getCurrentEvents(Object obj, Property prop) {
        if (!prop.isCollection()) {
            throw new IllegalArgumentException();
        }
        List evs = (List)this.m_collectionEvents.get(this.getKey(obj, prop));
        if (evs == null) {
            return Collections.EMPTY_LIST;
        }
        return evs;
    }

    public Collection getReachablePropertyEvents(Object obj) {
        ArrayList<PropertyEvent> result = new ArrayList<PropertyEvent>();
        ObjectType ot = this.m_ssn.getObjectType(obj);
        Iterator it = ot.getProperties().iterator();
        while (it.hasNext()) {
            Property prop = (Property)it.next();
            if (prop.isCollection()) {
                result.addAll(this.getCurrentEvents(obj, prop));
                continue;
            }
            PropertyEvent e = this.getLastEvent(obj, prop);
            if (e == null) continue;
            result.add(e);
        }
        return result;
    }
}

