/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence;

import com.redhat.persistence.Condition;
import com.redhat.persistence.common.Path;

public abstract class Expression {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/Expression.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public abstract void dispatch(Switch var1);

    public static final Variable variable(Path path) {
        return new Variable(path);
    }

    public static final Value value(Object value) {
        return new Value(value);
    }

    public static final Passthrough passthrough(String expr) {
        return new Passthrough(expr);
    }

    public static class Passthrough
    extends Expression {
        private String m_expr;

        private Passthrough(String expr) {
            this.m_expr = expr;
        }

        public void dispatch(Switch sw) {
            sw.onPassthrough(this);
        }

        public String getExpression() {
            return this.m_expr;
        }

        public String toString() {
            return this.m_expr;
        }
    }

    public static class Value
    extends Expression {
        private Object m_value;

        private Value(Object value) {
            this.m_value = value;
        }

        public void dispatch(Switch sw) {
            sw.onValue(this);
        }

        public Object getValue() {
            return this.m_value;
        }

        public String toString() {
            return "" + this.m_value;
        }
    }

    public static class Variable
    extends Expression {
        private Path m_path;

        private Variable(Path path) {
            this.m_path = path;
        }

        public void dispatch(Switch sw) {
            sw.onVariable(this);
        }

        public Path getPath() {
            return this.m_path;
        }

        public String toString() {
            return "" + this.m_path;
        }
    }

    public static abstract class Switch {
        public abstract void onCondition(Condition var1);

        public abstract void onVariable(Variable var1);

        public abstract void onValue(Value var1);

        public abstract void onPassthrough(Passthrough var1);
    }
}

