/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence;

import com.redhat.persistence.Event;
import com.redhat.persistence.ObjectData;
import com.redhat.persistence.Session;
import java.io.PrintWriter;

public abstract class ObjectEvent
extends Event {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/ObjectEvent.java#5 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private ObjectData m_odata;

    ObjectEvent(Session ssn, Object obj) {
        super(ssn, obj);
    }

    void setObjectData(ObjectData odata) {
        this.m_odata = odata;
    }

    ObjectData getObjectData() {
        return this.m_odata;
    }

    void prepare() {
        ObjectData od = this.getSession().getObjectData(this.getObject());
        if (od == null) {
            throw new IllegalStateException(this.toString());
        }
        this.setObjectData(od);
    }

    void activate() {
        ObjectEvent prev = this.getSession().getEventStream().getLastEvent(this.getObject());
        if (prev != null) {
            prev.addDependent(this);
        }
        this.getSession().getEventStream().add(this);
    }

    void sync() {
        this.getSession().getEventStream().remove(this);
    }

    void dump(PrintWriter out) {
        out.print("        ");
        out.println(this.getName());
    }

    public String toString() {
        return this.getName() + " " + this.getObject();
    }
}

