/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence;

import com.redhat.persistence.Event;
import com.redhat.persistence.ObjectData;
import com.redhat.persistence.PropertyEvent;
import com.redhat.persistence.Session;
import com.redhat.persistence.metadata.Property;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

class PropertyData {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/PropertyData.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private final ObjectData m_odata;
    private final Property m_prop;
    private Object m_value;
    private final List m_dependentEvents = new LinkedList();

    public PropertyData(ObjectData odata, Property prop, Object value) {
        this.m_odata = odata;
        this.m_prop = prop;
        this.m_value = value;
        this.m_odata.addPropertyData(this.m_prop, this);
    }

    ObjectData getObjectData() {
        return this.m_odata;
    }

    public Session getSession() {
        return this.m_odata.getSession();
    }

    private Object getObject() {
        return this.m_odata.getObject();
    }

    public Property getProperty() {
        return this.m_prop;
    }

    public void setValue(Object value) {
        if (this.getProperty().isCollection()) {
            throw new IllegalStateException("setting value of collections is not allowed. property: " + this.m_prop + " value: " + value);
        }
        this.m_value = value;
    }

    public Object getValue() {
        return this.m_value;
    }

    public Object get() {
        if (!this.m_prop.isCollection()) {
            PropertyEvent ev = this.getSession().getEventStream().getLastEvent(this.getObject(), this.getProperty());
            if (ev == null) {
                return this.m_value;
            }
            return ev.getArgument();
        }
        return this.m_value;
    }

    public boolean isFlushed() {
        if (this.m_prop.isCollection()) {
            Collection evs = this.getSession().getEventStream().getCurrentEvents(this.getObject(), this.getProperty());
            return evs.size() == 0;
        }
        return this.getSession().getEventStream().getLastEvent(this.getObject(), this.getProperty()) == null;
    }

    void addNotNullDependent(Event ev) {
        this.getSession().addViolation(this);
        this.m_dependentEvents.add(ev);
    }

    Iterator getDependentEvents() {
        return this.m_dependentEvents.iterator();
    }

    void transferNotNullDependentEvents(Event ev) {
        Iterator it = this.m_dependentEvents.iterator();
        while (it.hasNext()) {
            ev.addDependent((Event)it.next());
        }
        this.m_dependentEvents.clear();
        this.getSession().removeViolation(this);
    }

    void dump() {
        PrintWriter pw = new PrintWriter(System.out);
        this.dump(pw);
        pw.flush();
    }

    void dump(PrintWriter out) {
        out.print("    ");
        out.print(this.m_prop.getName());
        out.print(" = ");
        out.println(this.m_value);
        if (this.m_prop.isCollection()) {
            boolean first = true;
            Iterator it = this.getSession().getEventStream().getCurrentEvents(this.getObject(), this.getProperty()).iterator();
            while (it.hasNext()) {
                if (first) {
                    first = false;
                    out.println("    Current Property Events:");
                }
                ((Event)it.next()).dump(out);
            }
        } else {
            PropertyEvent ev = this.getSession().getEventStream().getLastEvent(this.getObject(), this.getProperty());
            if (ev != null) {
                out.println("    Current Property Events:");
                ((Event)ev).dump(out);
            }
        }
    }

    public String toString() {
        return "<pdata " + this.getObject() + "." + this.getProperty() + ">";
    }
}

