/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence.engine.rdbms;

import com.redhat.persistence.Event;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

class Node {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/engine/rdbms/Node.java#5 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private HashSet m_dependencies = new HashSet();
    private ArrayList m_events = new ArrayList();

    Node() {
    }

    public void addEvent(Event ev) {
        if (this.m_events.contains(ev)) {
            return;
        }
        this.m_events.add(ev);
    }

    public Collection getEvents() {
        return this.m_events;
    }

    public void addEvents(Collection c) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.addEvent((Event)it.next());
        }
    }

    public void addDependency(Event ev) {
        if (ev == null) {
            return;
        }
        if (this.m_dependencies.contains(ev) || this.m_events.contains(ev)) {
            return;
        }
        this.m_dependencies.add(ev);
    }

    public Collection getDependencies() {
        return this.m_dependencies;
    }

    public void addDependencies(Collection c) {
        if (c == null) {
            return;
        }
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.addDependency((Event)it.next());
        }
    }

    private boolean containsAny(Collection c, Collection candidates) {
        Iterator it = candidates.iterator();
        while (it.hasNext()) {
            if (!c.contains(it.next())) continue;
            return true;
        }
        return false;
    }

    public void merge(Node from) {
        if (from == this) {
            throw new IllegalArgumentException("cannot merge a node with itself");
        }
        if (this.containsAny(this.m_events, from.getDependencies())) {
            this.addEvents(from.getEvents());
        } else {
            ArrayList evs = this.m_events;
            this.m_events = new ArrayList(from.m_events);
            this.addEvents(evs);
        }
        this.m_dependencies.addAll(from.getDependencies());
        this.m_dependencies.removeAll(this.m_events);
    }

    public String toString() {
        return "<node events: " + this.m_events + "\n        deps: " + this.m_dependencies + ">";
    }
}

