/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence.engine.rdbms;

import com.redhat.persistence.Event;
import com.redhat.persistence.common.Path;
import com.redhat.persistence.engine.rdbms.ANSIWriter;
import com.redhat.persistence.engine.rdbms.Environment;
import com.redhat.persistence.engine.rdbms.RDBMSEngine;
import com.redhat.persistence.engine.rdbms.SQLWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

abstract class Operation {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/engine/rdbms/Operation.java#10 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger LOG = Logger.getLogger((Class)(class$com$redhat$persistence$engine$rdbms$Operation == null ? (class$com$redhat$persistence$engine$rdbms$Operation = Operation.class$("com.redhat.persistence.engine.rdbms.Operation")) : class$com$redhat$persistence$engine$rdbms$Operation));
    private RDBMSEngine m_engine;
    private Environment m_env;
    private HashSet m_parameters = new HashSet();
    private HashMap m_mappings = new HashMap();
    private ArrayList m_events = null;
    static /* synthetic */ Class class$com$redhat$persistence$engine$rdbms$Operation;

    protected Operation(RDBMSEngine engine, Environment env) {
        this.m_engine = engine;
        this.m_env = env;
    }

    protected Operation(RDBMSEngine engine) {
        this(engine, new Environment(engine, null));
    }

    public boolean isParameter(Path path) {
        return this.m_parameters.contains(path);
    }

    public void addParameter(Path path) {
        this.m_parameters.add(path);
    }

    public boolean contains(Path parameter) {
        return this.m_env.contains(parameter);
    }

    public void set(Path parameter, Object value) {
        this.m_parameters.add(parameter);
        this.m_env.set(parameter, value);
    }

    public void set(Path parameter, Object value, int type) {
        this.m_parameters.add(parameter);
        this.m_env.set(parameter, value, type);
    }

    public Object get(Path parameter) {
        return this.m_env.get(parameter);
    }

    public int getType(Path parameter) {
        return this.m_env.getType(parameter);
    }

    Environment getEnvironment() {
        return this.m_env;
    }

    public Path[] getMapping(Path p) {
        return (Path[])this.m_mappings.get(p);
    }

    public void setMapping(Path p, Path[] cols) {
        this.m_mappings.put(p, cols);
    }

    public void setMappings(Map map) {
        this.m_mappings.putAll(map);
    }

    void addEvent(Event ev) {
        if (ev == null) {
            throw new IllegalArgumentException("null event");
        }
        if (this.m_events == null) {
            this.m_events = new ArrayList();
        }
        if (!this.m_events.contains(ev)) {
            this.m_events.add(ev);
        }
    }

    Collection getEvents() {
        if (this.m_events == null) {
            return Collections.EMPTY_LIST;
        }
        return this.m_events;
    }

    abstract void write(SQLWriter var1);

    public String toString() {
        ANSIWriter w = new ANSIWriter();
        w.setEngine(this.m_engine);
        w.write(this);
        return w.getSQL() + "\n" + w.getBindings();
    }

    public final String toSafeString() {
        StringBuffer buf = new StringBuffer(128);
        buf.append("env=").append(this.m_env);
        buf.append("\nparameters=").append(this.m_parameters);
        buf.append("\nmappings=");
        if (this.m_mappings == null) {
            buf.append(this.m_mappings);
        } else {
            Iterator it = this.m_mappings.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                buf.append("\n  ");
                buf.append(entry.getKey()).append("=");
                buf.append(Arrays.asList((Path[])entry.getValue()));
            }
        }
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

