/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence.engine.rdbms;

import com.redhat.persistence.common.Path;
import com.redhat.persistence.engine.rdbms.Environment;
import com.redhat.persistence.engine.rdbms.Operation;
import com.redhat.persistence.engine.rdbms.RDBMSEngine;
import com.redhat.persistence.engine.rdbms.SQLWriter;
import com.redhat.persistence.metadata.SQLBlock;
import java.util.Iterator;

class StaticOperation
extends Operation {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/engine/rdbms/StaticOperation.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private SQLBlock m_sql;

    public StaticOperation(RDBMSEngine engine, SQLBlock sql, Environment env) {
        this(engine, sql, env, true);
    }

    public StaticOperation(RDBMSEngine engine, SQLBlock sql, Environment env, boolean initialize) {
        super(engine, env);
        this.m_sql = sql;
        Iterator it = sql.getSQL().getBindings().iterator();
        while (it.hasNext()) {
            Path p = (Path)it.next();
            this.addParameter(p);
            if (!initialize || env.contains(p)) continue;
            env.set(p, null);
        }
    }

    public SQLBlock getSQLBlock() {
        return this.m_sql;
    }

    public int getType(Path path) {
        if (this.m_sql.hasType(path)) {
            return this.m_sql.getType(path);
        }
        return super.getType(path);
    }

    void write(SQLWriter w) {
        w.write(this);
    }
}

