/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence.metadata;

import com.redhat.persistence.common.Path;
import com.redhat.persistence.metadata.Adapter;
import com.redhat.persistence.metadata.DataOperation;
import com.redhat.persistence.metadata.Mist;
import com.redhat.persistence.metadata.ObjectMap;
import com.redhat.persistence.metadata.ObjectType;
import com.redhat.persistence.metadata.Table;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Root {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/metadata/Root.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private HashMap m_locations = new HashMap();
    private Mist m_types = new Mist(this);
    private Mist m_maps = new Mist(this);
    private Mist m_tables = new Mist(this);
    private Mist m_ops = new Mist(this);
    private Map m_adapters = new HashMap();

    public void setLocation(Object element, String filename, int line, int column) {
        this.m_locations.put(element, new Location(filename, line, column));
    }

    public boolean hasLocation(Object element) {
        return this.m_locations.containsKey(element);
    }

    private Location getLocation(Object element) {
        Location result = (Location)this.m_locations.get(element);
        if (result == null) {
            throw new IllegalArgumentException("no such element: " + element);
        }
        return result;
    }

    public String getFilename(Object element) {
        return this.getLocation(element).getFilename();
    }

    public int getLine(Object element) {
        return this.getLocation(element).getLine();
    }

    public int getColumn(Object element) {
        return this.getLocation(element).getColumn();
    }

    public boolean hasObjectType(String qualifiedName) {
        return this.m_types.containsKey(qualifiedName);
    }

    public void addObjectType(ObjectType type) {
        this.m_types.add(type);
    }

    public ObjectType getObjectType(String qualifiedName) {
        return (ObjectType)this.m_types.get(qualifiedName);
    }

    public Collection getObjectTypes() {
        return this.m_types;
    }

    public ObjectMap getObjectMap(ObjectType type) {
        return (ObjectMap)this.m_maps.get(type);
    }

    public void addObjectMap(ObjectMap map) {
        this.m_maps.add(map);
    }

    public Collection getObjectMaps() {
        return this.m_maps;
    }

    public boolean hasTable(String name) {
        return this.m_tables.containsKey(name);
    }

    public Table getTable(String name) {
        return (Table)this.m_tables.get(name);
    }

    public void addTable(Table table) {
        this.m_tables.add(table);
    }

    public Collection getTables() {
        return this.m_tables;
    }

    public Collection getDataOperations() {
        return this.m_ops;
    }

    public void addDataOperation(DataOperation op) {
        this.m_ops.add(op);
    }

    public DataOperation getDataOperation(Path name) {
        return (DataOperation)this.m_ops.get(name);
    }

    public void addAdapter(Class javaClass, Adapter ad) {
        this.m_adapters.put(javaClass, ad);
        ad.setRoot(this);
    }

    public Adapter getAdapter(Class javaClass) {
        for (Class c = javaClass; c != null; c = c.getSuperclass()) {
            Adapter a = (Adapter)this.m_adapters.get(c);
            if (a == null) continue;
            return a;
        }
        return null;
    }

    public Adapter getAdapter(ObjectType type) {
        for (ObjectType ot = type; ot != null; ot = ot.getSupertype()) {
            Adapter a;
            Class klass = ot.getJavaClass();
            if (klass == null || (a = this.getAdapter(klass)) == null) continue;
            return a;
        }
        Adapter a = (Adapter)this.m_adapters.get(null);
        if (a != null) {
            return a;
        }
        return null;
    }

    public void dump(PrintStream out) {
        out.println("types:");
        this.dump(out, this.m_types);
        out.println("maps:");
        this.dump(out, this.m_maps);
        out.println("tables:");
        this.dump(out, this.m_tables);
        out.println("ops:");
        this.dump(out, this.m_ops);
        out.println("adapters:");
        this.dump(out, this.m_adapters);
    }

    private void dump(PrintStream out, Collection c) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            out.println("    " + it.next());
        }
    }

    private void dump(PrintStream out, Map m) {
        Iterator it = m.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            out.println("    " + me.getKey() + ": " + me.getValue());
        }
    }

    private static final class Location {
        private final String m_filename;
        private final int m_line;
        private final int m_column;

        public Location(String filename, int line, int column) {
            this.m_filename = filename;
            this.m_line = line;
            this.m_column = column;
        }

        public String getFilename() {
            return this.m_filename;
        }

        public int getLine() {
            return this.m_line;
        }

        public int getColumn() {
            return this.m_column;
        }
    }
}

