/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence.metadata;

import com.redhat.persistence.common.Path;
import com.redhat.persistence.common.SQL;
import com.redhat.persistence.common.SQLToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class SQLBlock {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/metadata/SQLBlock.java#5 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private SQL m_sql;
    private ArrayList m_assigns = new ArrayList();
    private HashMap m_mappings = new HashMap();
    private HashMap m_types = new HashMap();

    public SQLBlock(SQL sql) {
        this.m_sql = sql;
    }

    public SQL getSQL() {
        return this.m_sql;
    }

    public void addAssign(SQLToken begin, SQLToken end) {
        this.m_assigns.add(new Assign(begin, end));
    }

    public Collection getAssigns() {
        return this.m_assigns;
    }

    public boolean hasMapping(Path path) {
        return this.m_mappings.containsKey(path);
    }

    public void addMapping(Path path, Path column) {
        if (this.hasMapping(path)) {
            throw new IllegalArgumentException("already have mapping: " + path);
        }
        this.m_mappings.put(path, column);
    }

    public void removeMapping(Path path) {
        this.m_mappings.remove(path);
    }

    public Path getMapping(Path path) {
        return (Path)this.m_mappings.get(path);
    }

    public Collection getPaths() {
        return this.m_mappings.keySet();
    }

    public boolean hasType(Path path) {
        return this.m_types.containsKey(path);
    }

    public void addType(Path path, int type) {
        if (this.hasType(path)) {
            throw new IllegalArgumentException("already have mapping: " + path);
        }
        this.m_types.put(path, new Integer(type));
    }

    public int getType(Path path) {
        return (Integer)this.m_types.get(path);
    }

    public String toString() {
        return this.m_sql.toString() + "\n assigns = " + this.m_assigns;
    }

    public static class Assign {
        private SQLToken m_begin;
        private SQLToken m_end;

        private Assign(SQLToken begin, SQLToken end) {
            this.m_begin = begin;
            this.m_end = end;
        }

        public SQLToken getBegin() {
            return this.m_begin;
        }

        public SQLToken getEnd() {
            return this.m_end;
        }

        public String toString() {
            return SQL.toString(this.m_begin, this.m_end);
        }
    }
}

