/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence.metadata;

import com.redhat.persistence.metadata.Column;
import com.redhat.persistence.metadata.Constraint;
import com.redhat.persistence.metadata.ForeignKey;
import com.redhat.persistence.metadata.Table;
import java.util.HashSet;
import java.util.Set;

public class UniqueKey
extends Constraint {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/metadata/UniqueKey.java#5 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private Set m_foreignKeys = new HashSet();

    public UniqueKey(Table table, String name, Column[] columns) {
        super(UniqueKey.checkDuplicates(table, columns), name, columns);
    }

    private static final Table checkDuplicates(Table table, Column[] columns) {
        if (table.getUniqueKey(columns) != null) {
            throw new IllegalArgumentException("Table already has a unique key: " + table.getName());
        }
        return table;
    }

    public UniqueKey(String name, Column column) {
        this(column.getTable(), null, new Column[]{column});
    }

    public boolean isPrimaryKey() {
        return this.equals(this.getTable().getPrimaryKey());
    }

    public Set getForeignKeys() {
        return this.m_foreignKeys;
    }

    void addForeignKey(ForeignKey fk) {
        this.m_foreignKeys.add(fk);
    }

    public boolean isDeferred() {
        return false;
    }

    String getSuffix() {
        if (this.isPrimaryKey()) {
            return "_p";
        }
        return "_u";
    }

    String getColumnSQL() {
        String keyword;
        String string = keyword = this.isPrimaryKey() ? "primary key" : "unique";
        if (this.getName() == null) {
            return "        " + keyword;
        }
        return "        constraint " + this.getName() + "\n          " + keyword;
    }

    public String getSQL() {
        String keyword;
        String string = keyword = this.isPrimaryKey() ? "primary key" : "unique";
        if (this.getName() == null) {
            return "    " + keyword + this.getColumnList();
        }
        return "    constraint " + this.getName() + "\n      " + keyword + this.getColumnList();
    }
}

