/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence.oql;

import com.redhat.persistence.common.Path;
import com.redhat.persistence.metadata.ObjectMap;
import com.redhat.persistence.metadata.ObjectType;
import com.redhat.persistence.metadata.SQLBlock;
import com.redhat.persistence.oql.Code;
import com.redhat.persistence.oql.Expression;
import com.redhat.persistence.oql.Generator;
import com.redhat.persistence.oql.QFrame;
import com.redhat.persistence.oql.Static;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public class All
extends Expression {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/oql/All.java#5 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private String m_type;
    private Map m_bindings;
    private Expression m_scope;
    private boolean m_substitute;

    public All(String type) {
        this(type, Collections.EMPTY_MAP, null, false);
    }

    All(String type, Map bindings, Expression scope, boolean substitute) {
        this.m_type = type;
        this.m_bindings = bindings;
        this.m_scope = scope == null ? this : scope;
        this.m_substitute = substitute;
    }

    String getType() {
        return this.m_type;
    }

    void frame(Generator gen) {
        final ObjectType type = gen.getType(this.m_type);
        ObjectMap map = type.getRoot().getObjectMap(type);
        SQLBlock block = map.getRetrieveAll();
        String[] columns = Code.columns(type, null);
        if (block == null) {
            QFrame frame = gen.frame(this, type);
            frame.setTable(Code.table(map).getName());
            frame.setValues(columns);
        } else if (this.m_substitute || gen.isBoolean(this)) {
            Static all = new Static(block.getSQL(), null, false, this.m_bindings, this.m_scope);
            all.frame(gen);
            gen.setSubstitute(this, all);
        } else {
            QFrame frame = gen.frame(this, type);
            Static all = new Static(block.getSQL(), columns, false, this.m_bindings, this.m_scope){

                protected ObjectType getType() {
                    return type;
                }

                protected boolean hasType() {
                    return true;
                }
            };
            all.frame(gen);
            QFrame child = gen.getFrame(all);
            frame.addChild(child);
            frame.setValues(child.getValues());
            Iterator it = block.getPaths().iterator();
            while (it.hasNext()) {
                Path p = (Path)it.next();
                frame.addMapping(p, block.getMapping(p).getPath());
            }
        }
    }

    Code emit(Generator gen) {
        Expression sub = gen.getSubstitute(this);
        if (sub != null) {
            return sub.emit(gen);
        }
        return gen.getFrame(this).emit();
    }

    void hash(Generator gen) {
        ObjectType type = gen.getType(this.m_type);
        gen.hash(type);
        gen.hash(this.getClass());
    }

    public String toString() {
        return "all(" + this.m_type + ")";
    }

    String summary() {
        return "all: " + this.m_type;
    }
}

