/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence.oql;

import com.redhat.persistence.oql.Code;
import com.redhat.persistence.oql.Condition;
import com.redhat.persistence.oql.Expression;
import com.redhat.persistence.oql.Generator;
import com.redhat.persistence.oql.Static;

public abstract class BinaryCondition
extends Condition {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/oql/BinaryCondition.java#5 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    Expression m_left;
    Expression m_right;

    BinaryCondition(Expression left, Expression right) {
        this.m_left = left;
        this.m_right = right;
    }

    void frame(Generator gen) {
        this.m_left.frame(gen);
        this.m_right.frame(gen);
        gen.addUses(this, gen.getUses(this.m_left));
        gen.addUses(this, gen.getUses(this.m_right));
    }

    private Code paren(Code sql, Expression e) {
        if (e instanceof BinaryCondition || e instanceof Static) {
            sql = new Code("(").add(sql).add(")");
        }
        return sql;
    }

    Code emit(Code left, String op, Code right) {
        return this.paren(left, this.m_left).add(" ").add(op).add(" ").add(this.paren(right, this.m_right));
    }

    Code emit(Generator gen) {
        String op = this.getOperator();
        return this.emit(this.m_left.emit(gen), op, this.m_right.emit(gen));
    }

    void hash(Generator gen) {
        this.m_left.hash(gen);
        this.m_right.hash(gen);
        gen.hash(this.getClass());
    }

    private String str(Expression e) {
        if (e instanceof BinaryCondition) {
            return "(" + e + ")";
        }
        return e.toString();
    }

    public String toString() {
        return this.str(this.m_left) + " " + this.getOperator() + " " + this.str(this.m_right);
    }

    abstract String getOperator();

    String summary() {
        return this.getOperator();
    }
}

