/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence.pdl.adapters;

import com.arsdigita.db.DbHelper;
import com.redhat.persistence.pdl.adapters.SimpleAdapter;
import java.io.IOException;
import java.io.Writer;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import oracle.sql.CLOB;

public class StringAd
extends SimpleAdapter {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/pdl/adapters/StringAd.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public StringAd() {
        super("global.String", 12);
    }

    public void bind(PreparedStatement ps, int index, Object obj, int type) throws SQLException {
        ps.setString(index, (String)obj);
    }

    public Object fetch(ResultSet rs, String column) throws SQLException {
        ResultSetMetaData md = rs.getMetaData();
        if (md.getColumnType(rs.findColumn(column)) == 2005 && DbHelper.getDatabase(rs) != 2) {
            Clob clob = rs.getClob(column);
            if (clob == null) {
                return null;
            }
            return clob.getSubString(1L, (int)clob.length());
        }
        return rs.getString(column);
    }

    public boolean isMutation(Object value, int jdbcType) {
        return value != null && jdbcType == 2005;
    }

    public void mutate(ResultSet rs, String column, Object value, int jdbcType) throws SQLException {
        if (DbHelper.getDatabase(rs) == 2) {
            return;
        }
        CLOB clob = (CLOB)rs.getClob(column);
        Writer out = clob.getCharacterOutputStream();
        try {
            out.write(((String)value).toCharArray());
            out.flush();
            out.close();
        }
        catch (IOException e) {
            throw new Error("Unable to write LOB: " + e);
        }
    }
}

