/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.Hashtable;
import org.postgresql.util.PSQLException;

public class Encoding {
    private static final Encoding DEFAULT_ENCODING = new Encoding(null);
    private static final Hashtable encodings = new Hashtable();
    private final String encoding;
    private static final int pow2_6 = 64;
    private static final int pow2_12 = 4096;
    private char[] cdata = new char[50];

    private Encoding(String encoding) {
        this.encoding = encoding;
    }

    public static Encoding getEncoding(String databaseEncoding, String passedEncoding) {
        if (passedEncoding != null) {
            if (Encoding.isAvailable(passedEncoding)) {
                return new Encoding(passedEncoding);
            }
            return Encoding.defaultEncoding();
        }
        return Encoding.encodingForDatabaseEncoding(databaseEncoding);
    }

    private static Encoding encodingForDatabaseEncoding(String databaseEncoding) {
        if (encodings.containsKey(databaseEncoding)) {
            String[] candidates = (String[])encodings.get(databaseEncoding);
            int i = 0;
            while (i < candidates.length) {
                if (Encoding.isAvailable(candidates[i])) {
                    return new Encoding(candidates[i]);
                }
                ++i;
            }
        }
        return Encoding.defaultEncoding();
    }

    public String name() {
        return this.encoding;
    }

    public byte[] encode(String s) throws SQLException {
        try {
            if (this.encoding == null) {
                return s.getBytes();
            }
            return s.getBytes(this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new PSQLException("postgresql.stream.encoding", e);
        }
    }

    public String decode(byte[] encodedString, int offset, int length) throws SQLException {
        try {
            if (this.encoding == null) {
                return new String(encodedString, offset, length);
            }
            if (this.encoding.equals("UTF-8")) {
                return this.decodeUTF8(encodedString, offset, length);
            }
            return new String(encodedString, offset, length, this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new PSQLException("postgresql.stream.encoding", e);
        }
    }

    public String decode(byte[] encodedString) throws SQLException {
        return this.decode(encodedString, 0, encodedString.length);
    }

    public Reader getDecodingReader(InputStream in) throws SQLException {
        try {
            if (this.encoding == null) {
                return new InputStreamReader(in);
            }
            return new InputStreamReader(in, this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new PSQLException("postgresql.res.encoding", e);
        }
    }

    public static Encoding defaultEncoding() {
        return DEFAULT_ENCODING;
    }

    private static boolean isAvailable(String encodingName) {
        try {
            "DUMMY".getBytes(encodingName);
            return true;
        }
        catch (UnsupportedEncodingException e) {
            return false;
        }
    }

    private synchronized String decodeUTF8(byte[] data, int offset, int length) throws SQLException {
        try {
            char[] l_cdata = this.cdata;
            if (l_cdata.length < length) {
                l_cdata = new char[length];
            }
            int i = offset;
            int j = 0;
            int k = length + offset;
            while (i < k) {
                int val;
                int y;
                int z = data[i] & 0xFF;
                if (z < 128) {
                    l_cdata[j++] = (char)data[i];
                    ++i;
                    continue;
                }
                if (z >= 224) {
                    y = data[i + 1] & 0xFF;
                    int x = data[i + 2] & 0xFF;
                    val = (z - 224) * 4096 + (y - 128) * 64 + (x - 128);
                    l_cdata[j++] = (char)val;
                    i += 3;
                    continue;
                }
                y = data[i + 1] & 0xFF;
                val = (z - 192) * 64 + (y - 128);
                l_cdata[j++] = (char)val;
                i += 2;
            }
            String s = new String(l_cdata, 0, j);
            return s;
        }
        catch (Exception l_e) {
            throw new PSQLException("postgresql.con.invalidchar", l_e);
        }
    }

    static {
        encodings.put("SQL_ASCII", new String[]{"ASCII", "us-ascii"});
        encodings.put("UNICODE", new String[]{"UTF-8", "UTF8"});
        encodings.put("LATIN1", new String[]{"ISO8859_1"});
        encodings.put("LATIN2", new String[]{"ISO8859_2"});
        encodings.put("LATIN3", new String[]{"ISO8859_3"});
        encodings.put("LATIN4", new String[]{"ISO8859_4"});
        encodings.put("ISO_8859_5", new String[]{"ISO8859_5"});
        encodings.put("ISO_8859_6", new String[]{"ISO8859_6"});
        encodings.put("ISO_8859_7", new String[]{"ISO8859_7"});
        encodings.put("ISO_8859_8", new String[]{"ISO8859_8"});
        encodings.put("LATIN5", new String[]{"ISO8859_9"});
        encodings.put("LATIN7", new String[]{"ISO8859_13"});
        encodings.put("LATIN9", new String[]{"ISO8859_15_FDIS"});
        encodings.put("EUC_JP", new String[]{"EUC_JP"});
        encodings.put("EUC_CN", new String[]{"EUC_CN"});
        encodings.put("EUC_KR", new String[]{"EUC_KR"});
        encodings.put("JOHAB", new String[]{"Johab"});
        encodings.put("EUC_TW", new String[]{"EUC_TW"});
        encodings.put("SJIS", new String[]{"MS932", "SJIS"});
        encodings.put("BIG5", new String[]{"Big5", "MS950", "Cp950"});
        encodings.put("GBK", new String[]{"GBK", "MS936"});
        encodings.put("UHC", new String[]{"MS949", "Cp949", "Cp949C"});
        encodings.put("TCVN", new String[]{"Cp1258"});
        encodings.put("WIN1256", new String[]{"Cp1256"});
        encodings.put("WIN1250", new String[]{"Cp1250"});
        encodings.put("WIN874", new String[]{"MS874", "Cp874"});
        encodings.put("WIN", new String[]{"Cp1251"});
        encodings.put("ALT", new String[]{"Cp866"});
        encodings.put("KOI8", new String[]{"KOI8_U", "KOI8_R"});
        encodings.put("UNKNOWN", new String[0]);
        encodings.put("MULE_INTERNAL", new String[0]);
        encodings.put("LATIN6", new String[0]);
        encodings.put("LATIN8", new String[0]);
        encodings.put("LATIN10", new String[0]);
    }
}

