/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import org.postgresql.jdbc1.AbstractJdbc1Connection;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.largeobject.LargeObjectManager;
import org.postgresql.util.PSQLException;

public class PGLOInputStream {
    protected AbstractJdbc1Connection connection;
    private InputStream stream;
    private int LOlength;
    private int LOoid;
    private LargeObject lob;
    boolean isMaterialized;

    public PGLOInputStream(AbstractJdbc1Connection connection, InputStream stream, int length) {
        this.connection = connection;
        this.stream = stream;
        this.LOlength = length;
        this.lob = null;
        this.LOoid = 0;
        this.isMaterialized = false;
    }

    public void materialize() throws SQLException {
        LargeObjectManager lom = this.connection.getLargeObjectAPI();
        this.LOoid = lom.create();
        this.lob = lom.open(this.LOoid);
        OutputStream los = this.lob.getOutputStream();
        try {
            int c = this.stream.read();
            int p = 0;
            while (c > -1 && p < this.LOlength) {
                los.write(c);
                c = this.stream.read();
                ++p;
            }
            los.close();
        }
        catch (IOException se) {
            throw new PSQLException("postgresql.unusual", se);
        }
        this.isMaterialized = true;
    }

    public void dematerialize() throws SQLException {
        LargeObjectManager lom = this.connection.getLargeObjectAPI();
        lom.delete(this.LOoid);
        this.LOoid = 0;
        this.isMaterialized = false;
    }

    public String toString() {
        return "loread( lo_open(" + this.LOoid + ", x'60000'::INTEGER), " + this.LOlength + " )";
    }
}

